package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.presentation.form.*;
import com.ibatis.jpetstore.domain.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class NewOrderFormAction extends SecureBaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    AccountForm acctForm = (AccountForm) request.getSession().getAttribute("accountForm");
    CartForm cartForm = (CartForm) request.getSession().getAttribute("cartForm");

    if (cartForm != null) {
      OrderForm orderForm = (OrderForm) form;

      // Re-read account from DB at team's request.
      Account account = petStore.getAccount(acctForm.getAccount().getUsername());

      orderForm.getOrder().initOrder(account, cartForm.getCart());
      return mapping.findForward("success");
    } else {
      request.setAttribute("message", "An order could not be created because a cart could not be found.");
      return mapping.findForward("failure");
    }

  }

}