package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.presentation.form.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class AddItemToCartAction extends BaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    CartForm cartForm = (CartForm) form;
    Cart cart = cartForm.getCart();
    String workingItemId = cartForm.getWorkingItemId();

    if (cart.containsItemId(workingItemId)) {
      cart.incrementQuantityByItemId(workingItemId);
    } else {
      // isInStock is a "real-time" property that must be updated
      // every time an item is added to the cart, even if other
      // item details are cached.
      boolean isInStock = petStore.isItemInStock(workingItemId);
      Item item = petStore.getItem(workingItemId);
      cartForm.getCart().addItem(item, isInStock);
    }

//TODO - Get rid of this.
//    AccountForm acctForm = (AccountForm) request.getSession().getAttribute("accountForm");
//    if (acctForm != null && acctForm.getAccount() != null) {
//      if (request.getSession().getAttribute("myList") == null) {
//        int maxResults = acctForm.getMyListPage().getPageSize();
//        int skipResults = (acctForm.getMyListPage().getPageIndex() - 1) * maxResults;
//        request.setAttribute("myList", petStore.getProductListByCategory(acctForm.getAccount().getFavouriteCategoryId()));
//      }
//    }

    return mapping.findForward("success");
  }


}
