/**
 * User: Clinton Begin
 * Date: Jul 13, 2003
 * Time: 8:28:49 PM
 */
package com.ibatis.jpetstore.persistence.dao.sqlmapdao.oracle;

import com.ibatis.jpetstore.persistence.dao.sqlmapdao.*;
import com.ibatis.jpetstore.domain.*;
import com.ibatis.db.dao.*;

public class SequenceOracleDao extends SequenceSqlMapDao {

  /**
   * Get's the next sequence using an Oracle thread-safe sequence
   *
   * @param name Name is the name of the oracle sequence.
   * @return The next sequence.
   * @throws com.ibatis.db.dao.DaoException
   */
  public int getNextId(String name)
      throws DaoException {
    Sequence sequence = new Sequence();
    sequence.setName(name);
    sequence = (Sequence) executeQueryForObject("oracleSequence", sequence);
    return sequence.getNextId();
  }


}
