/**
 * User: Clinton Begin
 * Date: Jul 13, 2003
 * Time: 7:20:47 PM
 */
package com.ibatis.jpetstore.persistence.dao.sqlmapdao;

import com.ibatis.db.dao.*;
import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.persistence.dao.iface.*;

import java.util.*;

public class OrderSqlMapDao extends BaseSqlMapDao implements OrderDao {

  public List getOrdersByUsername(String username)
      throws DaoException {
    return executeQueryForList("getOrdersByUsername", username);
  }

  public Order getOrder(int orderId)
      throws DaoException {
    Order order = null;
    Object parameterObject = new Integer(orderId);
    order = (Order) executeQueryForObject("getOrder", parameterObject);
    order.setLineItems(executeQueryForList("getLineItemsByOrderId", new Integer(order.getOrderId())));
    return order;
  }

  protected void doInsertOrder(Order order)
      throws DaoException {
    executeUpdate("insertOrder", order);
    executeUpdate("insertOrderStatus", order);
  }

  public void insertOrder(Order order) throws DaoException {
    doInsertOrder(order);
    for (int i = 0; i < order.getLineItems().size(); i++) {
      LineItem lineItem = (LineItem) order.getLineItems().get(i);
      lineItem.setOrderId(order.getOrderId());
      executeUpdate("insertLineItem", lineItem);
    }

  }

}
