/**
 * User: Clinton Begin
 * Date: Jul 13, 2003
 * Time: 7:20:13 PM
 */
package com.ibatis.jpetstore.persistence.dao.sqlmapdao;

import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.persistence.dao.iface.*;
import com.ibatis.db.dao.*;

import java.util.*;

public class AccountSqlMapDao extends BaseSqlMapDao implements AccountDao {

  public Account getAccount(String username)
      throws DaoException {
    return (Account) executeQueryForObject("getAccountByUsername", username);
  }

  public List getUsernameList()
      throws DaoException {
    return executeQueryForList("getUsernameList", null);
  }

  public Account getAccount(String username, String password)
      throws DaoException {
    Account account = new Account();
    account.setUsername(username);
    account.setPassword(password);
    return (Account) executeQueryForObject("getAccountByUsernameAndPassword", account);
  }

  public void insertAccount(Account account)
      throws DaoException {
    executeUpdate("insertAccount", account);
    executeUpdate("insertProfile", account);
    executeUpdate("insertSignon", account);
  }

  public void updateAccount(Account account)
      throws DaoException {
    executeUpdate("updateAccount", account);
    executeUpdate("updateProfile", account);

    if (account.getPassword() != null && account.getPassword().length() > 0) {
      executeUpdate("updateSignon", account);
    }
  }


}
