/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.lang.reflect.Array;

public class ConvertUtils {
    private static Boolean defaultBoolean = Boolean.FALSE;
    private static Byte defaultByte = new Byte(0);
    private static Character defaultCharacter = new Character(' ');
    private static Double defaultDouble = new Double(0.0);
    private static Float defaultFloat = new Float(0.0f);
    private static Integer defaultInteger = new Integer(0);
    private static Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);
    private static Class stringClass = class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;

    public boolean getDefaultBoolean() {
        return defaultBoolean;
    }

    public void setDefaultBoolean(boolean defaultBoolean) {
        ConvertUtils.defaultBoolean = new Boolean(defaultBoolean);
    }

    public byte getDefaultByte() {
        return defaultByte;
    }

    public void setDefaultByte(byte defaultByte) {
        ConvertUtils.defaultByte = new Byte(defaultByte);
    }

    public char getDefaultCharacter() {
        return defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char defaultCharacter) {
        ConvertUtils.defaultCharacter = new Character(defaultCharacter);
    }

    public double getDefaultDouble() {
        return defaultDouble;
    }

    public void setDefaultDouble(double defaultDouble) {
        ConvertUtils.defaultDouble = new Double(defaultDouble);
    }

    public float getDefaultFloat() {
        return defaultFloat.floatValue();
    }

    public void setDefaultFloat(float defaultFloat) {
        ConvertUtils.defaultFloat = new Float(defaultFloat);
    }

    public int getDefaultInteger() {
        return defaultInteger;
    }

    public void setDefaultInteger(int defaultInteger) {
        ConvertUtils.defaultInteger = new Integer(defaultInteger);
    }

    public long getDefaultLong() {
        return defaultLong;
    }

    public void setDefaultLong(long defaultLong) {
        ConvertUtils.defaultLong = new Long(defaultLong);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short defaultShort) {
        ConvertUtils.defaultShort = new Short(defaultShort);
    }

    public static String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            return value.toString();
        }
        return value.toString();
    }

    public static Object convert(String value, Class clazz) {
        if (clazz == stringClass) {
            if (value == null) {
                return null;
            }
            return value;
        }
        if (clazz == Integer.TYPE) {
            return ConvertUtils.convertInteger(value, defaultInteger);
        }
        if (clazz == Boolean.TYPE) {
            return ConvertUtils.convertBoolean(value, defaultBoolean);
        }
        if (clazz == Long.TYPE) {
            return ConvertUtils.convertLong(value, defaultLong);
        }
        if (clazz == Double.TYPE) {
            return ConvertUtils.convertDouble(value, defaultDouble);
        }
        if (clazz == Character.TYPE) {
            return ConvertUtils.convertCharacter(value, defaultCharacter);
        }
        if (clazz == Byte.TYPE) {
            return ConvertUtils.convertByte(value, defaultByte);
        }
        if (clazz == Float.TYPE) {
            return ConvertUtils.convertFloat(value, defaultFloat);
        }
        if (clazz == Short.TYPE) {
            return ConvertUtils.convertShort(value, defaultShort);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return ConvertUtils.convertInteger(value, null);
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return ConvertUtils.convertBoolean(value, null);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return ConvertUtils.convertLong(value, null);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return ConvertUtils.convertDouble(value, null);
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtils.class$("java.lang.Character")) : class$java$lang$Character)) {
            return ConvertUtils.convertCharacter(value, null);
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return ConvertUtils.convertByte(value, null);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return ConvertUtils.convertFloat(value, null);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return ConvertUtils.convertShort(value, null);
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Object convert(String[] values, Class clazz) {
        Class<?> type = clazz.getComponentType();
        if (type == stringClass) {
            if (values == null) {
                return null;
            }
            return values;
        }
        int len = values.length;
        if (type == Integer.TYPE) {
            int[] array = new int[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertInteger(values[i], defaultInteger);
                ++i;
            }
            return array;
        }
        if (type == Boolean.TYPE) {
            boolean[] array = new boolean[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertBoolean(values[i], defaultBoolean);
                ++i;
            }
            return array;
        }
        if (type == Long.TYPE) {
            long[] array = new long[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertLong(values[i], defaultLong);
                ++i;
            }
            return array;
        }
        if (type == Double.TYPE) {
            double[] array = new double[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertDouble(values[i], defaultDouble);
                ++i;
            }
            return array;
        }
        if (type == Character.TYPE) {
            char[] array = new char[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertCharacter(values[i], defaultCharacter).charValue();
                ++i;
            }
            return array;
        }
        if (type == Byte.TYPE) {
            byte[] array = new byte[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertByte(values[i], defaultByte);
                ++i;
            }
            return array;
        }
        if (type == Float.TYPE) {
            float[] array = new float[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertFloat(values[i], defaultFloat).floatValue();
                ++i;
            }
            return array;
        }
        if (type == Short.TYPE) {
            short[] array = new short[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertShort(values[i], defaultShort);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            Integer[] array = new Integer[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertInteger(values[i], null);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            Boolean[] array = new Boolean[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertBoolean(values[i], null);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            Long[] array = new Long[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertLong(values[i], null);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            Double[] array = new Double[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertDouble(values[i], null);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtils.class$("java.lang.Character")) : class$java$lang$Character)) {
            Character[] array = new Character[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertCharacter(values[i], null);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            Byte[] array = new Byte[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertByte(values[i], null);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            Float[] array = new Float[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertFloat(values[i], null);
                ++i;
            }
            return array;
        }
        if (type == (class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            Short[] array = new Short[len];
            int i = 0;
            while (i < len) {
                array[i] = ConvertUtils.convertShort(values[i], null);
                ++i;
            }
            return array;
        }
        if (values == null) {
            return null;
        }
        String[] array = new String[len];
        int i = 0;
        while (i < len) {
            array[i] = values[i].toString();
            ++i;
        }
        return array;
    }

    private static Boolean convertBoolean(String value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("no") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        return defaultValue;
    }

    private static Byte convertByte(String value, Byte defaultValue) {
        try {
            return new Byte(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Character convertCharacter(String value, Character defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return new Character(value.charAt(0));
    }

    private static Double convertDouble(String value, Double defaultValue) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Float convertFloat(String value, Float defaultValue) {
        try {
            return new Float(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Integer convertInteger(String value, Integer defaultValue) {
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Long convertLong(String value, Long defaultValue) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Short convertShort(String value, Short defaultValue) {
        try {
            return new Short(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

