/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.digester;

import org.apache.struts.digester.Digester;
import org.apache.struts.digester.Rule;
import org.xml.sax.AttributeList;

public class ObjectCreateRule
extends Rule {
    protected String attributeName = null;
    protected String className = null;

    public ObjectCreateRule(Digester digester, String className) {
        this(digester, className, null);
    }

    public ObjectCreateRule(Digester digester, String className, String attributeName) {
        super(digester);
        this.className = className;
        this.attributeName = attributeName;
    }

    public void begin(AttributeList attributes) throws Exception {
        String value;
        String realClassName = this.className;
        if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
            realClassName = value;
        }
        if (this.digester.getDebug() >= 1) {
            this.digester.log("New " + realClassName);
        }
        Class<?> clazz = Class.forName(realClassName);
        Object instance = clazz.newInstance();
        this.digester.push(instance);
    }

    public void end() throws Exception {
        Object top = this.digester.pop();
        if (this.digester.getDebug() >= 1) {
            this.digester.log("Pop " + top.getClass().getName());
        }
    }

    public void finish() throws Exception {
        this.attributeName = null;
        this.className = null;
    }
}

