/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.typehandler;

import com.ibatis.db.sqlmap.ParameterMapping;
import com.ibatis.db.sqlmap.ResultMapping;
import com.ibatis.db.sqlmap.typehandler.BaseTypeHandler;
import com.ibatis.db.sqlmap.value.StringValue;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StringTypeHandler
extends BaseTypeHandler {
    protected Object getValueByName(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        String string = null;
        if ("CLOB".equals(resultMapping.getType())) {
            Clob clob = resultSet.getClob(resultMapping.getColumnName());
            if (clob != null) {
                string = clob.getSubString(1L, (int)clob.length());
            }
        } else {
            string = resultSet.getString(resultMapping.getColumnName());
        }
        return string;
    }

    protected Object getValueByIndex(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        String string = null;
        if ("CLOB".equals(resultMapping.getType())) {
            Clob clob = resultSet.getClob(resultMapping.getColumnIndex());
            if (clob != null) {
                string = clob.getSubString(1L, (int)clob.length());
            }
        } else {
            string = resultSet.getString(resultMapping.getColumnIndex());
        }
        return string;
    }

    protected Object getNullValue(String string) throws SQLException {
        return string;
    }

    public Object instantiateValue() {
        return new StringValue();
    }

    public boolean isEqualToNullValue(String string, Object object) {
        return string.equals(object);
    }

    public boolean isSimpleType() {
        return true;
    }

    public void setParameter(ParameterMapping parameterMapping, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        preparedStatement.setString(n, (String)object);
    }
}

