/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.typehandler;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.db.sqlmap.ParameterMapping;
import com.ibatis.db.sqlmap.ResultMapping;
import com.ibatis.db.sqlmap.TypeRegistry;
import com.ibatis.db.sqlmap.typehandler.BaseTypeHandler;
import com.ibatis.db.sqlmap.value.DateValue;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTypeHandler
extends BaseTypeHandler {
    private static final String DATE_FORMAT = "yyyy/MM/dd hh:mm:ss";
    private static final DateFormat format = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");

    protected Object getValueByName(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        Date date = null;
        int n = -99999;
        if (resultMapping.getType() != null) {
            n = TypeRegistry.getType(resultMapping.getType());
        }
        if (91 == n) {
            java.sql.Date date2 = resultSet.getDate(resultMapping.getColumnName());
            if (date2 != null) {
                date = new Date(date2.getTime());
            }
        } else if (92 == n) {
            Time time = resultSet.getTime(resultMapping.getColumnName());
            if (time != null) {
                date = new Date(time.getTime());
            }
        } else {
            Timestamp timestamp = resultSet.getTimestamp(resultMapping.getColumnName());
            if (timestamp != null) {
                date = new Date(((Date)timestamp).getTime());
            }
        }
        return date;
    }

    protected Object getValueByIndex(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        Date date = null;
        int n = -99999;
        if (resultMapping.getType() != null) {
            n = TypeRegistry.getType(resultMapping.getType());
        }
        if (91 == n) {
            java.sql.Date date2 = resultSet.getDate(resultMapping.getColumnIndex());
            if (date2 != null) {
                date = new Date(date2.getTime());
            }
        } else if (92 == n) {
            Time time = resultSet.getTime(resultMapping.getColumnIndex());
            if (time != null) {
                date = new Date(time.getTime());
            }
        } else {
            Timestamp timestamp = resultSet.getTimestamp(resultMapping.getColumnIndex());
            if (timestamp != null) {
                date = new Date(((Date)timestamp).getTime());
            }
        }
        return date;
    }

    protected Object getNullValue(String string) throws SQLException {
        try {
            return format.parse(string);
        }
        catch (ParseException parseException) {
            throw new SQLException("Error parsing default null value date.  Format must be 'yyyy/MM/dd hh:mm:ss'. Cause: " + parseException);
        }
    }

    public Object instantiateValue() {
        return new DateValue();
    }

    public boolean isEqualToNullValue(String string, Object object) {
        try {
            return format.parse(string).equals(object);
        }
        catch (ParseException parseException) {
            throw new NestedRuntimeException("Error parsing default null value date.  Format must be 'yyyy/MM/dd hh:mm:ss'. Cause: " + parseException, parseException);
        }
    }

    public boolean isSimpleType() {
        return true;
    }

    public void setParameter(ParameterMapping parameterMapping, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        long l = ((Date)object).getTime();
        int n2 = TypeRegistry.getType(parameterMapping.getType());
        if (91 == n2) {
            java.sql.Date date = new java.sql.Date(l);
            preparedStatement.setDate(n, date);
        } else if (92 == n2) {
            Time time = new Time(l);
            preparedStatement.setTime(n, time);
        } else {
            Timestamp timestamp = new Timestamp(l);
            preparedStatement.setTimestamp(n, timestamp);
        }
    }
}

