/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import com.ibatis.common.beans.StaticBeanProbe;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.db.sqlmap.Cache;
import com.ibatis.db.sqlmap.MappedStatement;
import com.ibatis.db.sqlmap.ParameterMap;
import com.ibatis.db.sqlmap.ParameterMapping;
import com.ibatis.db.sqlmap.ResultMap;
import com.ibatis.db.sqlmap.ResultMapping;
import com.ibatis.db.sqlmap.SqlMap;
import com.ibatis.db.sqlmap.SqlMapException;
import com.ibatis.db.sqlmap.SqlMapJarEntityResolver;
import com.ibatis.db.sqlmap.datasource.DataSourceFactory;
import com.ibatis.db.sqlmap.dynamic.BaseFragment;
import com.ibatis.db.sqlmap.dynamic.ConditionalFragment;
import com.ibatis.db.sqlmap.dynamic.DynamicFragment;
import com.ibatis.db.sqlmap.dynamic.DynamicMappedStatement;
import com.ibatis.db.sqlmap.dynamic.IsEmptyFragment;
import com.ibatis.db.sqlmap.dynamic.IsEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsGreaterEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsGreaterThanFragment;
import com.ibatis.db.sqlmap.dynamic.IsLessEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsLessThanFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotEmptyFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotNullFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotParameterPresentFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotPropertyAvailableFragment;
import com.ibatis.db.sqlmap.dynamic.IsNullFragment;
import com.ibatis.db.sqlmap.dynamic.IsParameterPresentFragment;
import com.ibatis.db.sqlmap.dynamic.IsPropertyAvailableFragment;
import com.ibatis.db.sqlmap.dynamic.IterateFragment;
import com.ibatis.db.sqlmap.dynamic.StaticFragment;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class XmlSqlMapBuilder {
    private static final String PARAMETER_TOKEN = "#";
    private static final String DOT = ".";
    private static final String SETTINGS_ELEMENT = "settings";
    private static final String SQL_CONFIG_ELEMENT = "sql-map-config";
    private static final String DATASOURCE_ELEMENT = "datasource";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String SQL_MAP_ELEMENT = "sql-map";
    private static final String RESULT_MAP_ELEMENT = "result-map";
    private static final String PARAMETER_MAP_ELEMENT = "parameter-map";
    private static final String MAPPED_STATEMENT_ELEMENT = "mapped-statement";
    private static final String CACHE_MODEL_ELEMENT = "cache-model";
    private static final String DYNAMIC_MAPPED_STATEMENT_ELEMENT = "dynamic-mapped-statement";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String FLUSH_INTERVAL_ELEMENT = "flush-interval";
    private static final String FLUSH_ON_EXECUTE_ELEMENT = "flush-on-execute";
    private static Properties properties;
    private static boolean validationEnabled;

    public static boolean isValidationEnabled() {
        return validationEnabled;
    }

    public static void setValidationEnabled(boolean bl) {
        validationEnabled = bl;
    }

    public static SqlMap buildSqlMap(File file) {
        SqlMap sqlMap;
        block7: {
            sqlMap = new SqlMap();
            try {
                if (file != null) {
                    if (file.isFile()) {
                        XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, new FileReader(file), file.getAbsolutePath(), false);
                        break block7;
                    }
                    if (file.isDirectory()) {
                        File[] fileArray = file.listFiles();
                        int n = 0;
                        while (n < fileArray.length) {
                            if (fileArray[n].getName().endsWith(".xml")) {
                                XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, new FileReader(fileArray[n]), fileArray[n].getAbsolutePath(), false);
                            }
                            ++n;
                        }
                        break block7;
                    }
                    throw new SqlMapException("Unkown error with input file/directory passed to XmlSqlMapBuilder.buildSqlMap().");
                }
                throw new SqlMapException("Input file/directory passed to XmlSqlMapBuilder.buildSqlMap() was NULL.");
            }
            catch (Exception exception) {
                throw new SqlMapException("Error in XmlSqlMapBuilder.buildSqlMap(). \n\nCause: \n\n" + exception, exception);
            }
        }
        XmlSqlMapBuilder.registerCacheMappings(sqlMap);
        return sqlMap;
    }

    public static SqlMap buildSqlMap(Reader reader) {
        return XmlSqlMapBuilder.buildSqlMap(reader, false);
    }

    public static SqlMap buildSqlMap(Reader reader, boolean bl) {
        try {
            SqlMap sqlMap = new SqlMap();
            XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, reader, "[Reader passed to buildSqlMap()]", bl);
            XmlSqlMapBuilder.registerCacheMappings(sqlMap);
            return sqlMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SqlMapException("Error while building SqlMap.  \n\nCause: \n\n" + exception, exception);
        }
    }

    private static void parseSqlMapRoot(SqlMap sqlMap, Reader reader, String string, boolean bl) throws IOException, JDOMException {
        properties = null;
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setEntityResolver((EntityResolver)new SqlMapJarEntityResolver());
        sAXBuilder.setValidation(validationEnabled);
        Document document = sAXBuilder.build(reader);
        Element element = document.getRootElement();
        String string2 = element.getName();
        if (SQL_MAP_ELEMENT.equals(string2)) {
            XmlSqlMapBuilder.includeSqlMap(sqlMap, element, string);
        } else if (SQL_CONFIG_ELEMENT.equals(string2)) {
            XmlSqlMapBuilder.parseSqlMapConfig(sqlMap, element, string, bl);
        } else {
            throw new IOException("The root tag of the SqlMap XML document must be 'sql-map' or 'sql-map-config'.");
        }
    }

    private static void registerCacheMappings(SqlMap sqlMap) {
        Iterator iterator = sqlMap.getCaches();
        while (iterator.hasNext()) {
            Cache cache = (Cache)iterator.next();
            Iterator iterator2 = cache.getFlushTriggerStatements();
            while (iterator2.hasNext()) {
                try {
                    String string = (String)iterator2.next();
                    MappedStatement mappedStatement = sqlMap.getMappedStatement(string);
                    mappedStatement.addExecuteListener(cache);
                }
                catch (SqlMapException sqlMapException) {
                    throw new SqlMapException("Error registering cache '" + cache.getName() + "' in '" + cache.getResourceName() + "'. Cause: " + sqlMapException.toString(), sqlMapException);
                }
            }
        }
    }

    private static void parseSqlMapConfig(SqlMap sqlMap, Element element, String string, boolean bl) throws IOException, JDOMException {
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            String string2;
            Element element2 = (Element)list.get(n);
            if (SQL_MAP_ELEMENT.equals(element2.getName())) {
                string2 = XmlSqlMapBuilder.getAttributeValue(element2, "resource", true);
                XmlSqlMapBuilder.includeSqlMap(sqlMap, string2, bl);
            } else if (PROPERTIES_ELEMENT.equals(element2.getName())) {
                string2 = XmlSqlMapBuilder.getAttributeValue(element2, "resource", true);
                properties = Resources.getResourceAsProperties(string2);
            } else if (SETTINGS_ELEMENT.equals(element2.getName())) {
                XmlSqlMapBuilder.parseSettingsElement(sqlMap, element2);
            } else if (DATASOURCE_ELEMENT.equals(element2.getName())) {
                if (!bl) {
                    XmlSqlMapBuilder.parseDataSource(sqlMap, element2, string);
                }
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            ++n;
        }
    }

    private static void parseSettingsElement(SqlMap sqlMap, Element element) {
        String string;
        int n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "maxExecute", false);
        if (n > 0) {
            sqlMap.setMaxExecute(n);
        }
        if ((n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "maxExecutePerConnection", false)) > 0) {
            sqlMap.setMaxExecutePerConnection(n);
        }
        if ((n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "maxTransactions", false)) > 0) {
            sqlMap.setMaxTransactions(n);
        }
        if ((n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "statementCacheSize", false)) > 0) {
            sqlMap.setStatementCacheSize(n);
        }
        if ((string = XmlSqlMapBuilder.getAttributeValue(element, "userTransactionJndiName", false)) != null && string.length() > 0) {
            sqlMap.setUserTransactionJndiName(string);
        }
        sqlMap.setUseGlobalTransaction("true".equals(XmlSqlMapBuilder.getAttributeValue(element, "useGlobalTransactions", false)));
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, "useBeansMetaClasses", false);
        if (string2 != null) {
            StaticBeanProbe.setUseMetaClasses("true".equals(string2));
        } else {
            StaticBeanProbe.setUseMetaClasses(false);
        }
        String string3 = XmlSqlMapBuilder.getAttributeValue(element, "useFullyQualifiedStatementNames", false);
        if (string3 != null) {
            sqlMap.setUseFullyQualifiedStatementNames("true".equals(string3));
        } else {
            sqlMap.setUseFullyQualifiedStatementNames(false);
        }
        String string4 = XmlSqlMapBuilder.getAttributeValue(element, "cacheModelsEnabled", false);
        if (string4 != null) {
            sqlMap.setCacheModelsEnabled("true".equals(string4));
        } else {
            sqlMap.setCacheModelsEnabled(true);
        }
        String string5 = XmlSqlMapBuilder.getAttributeValue(element, "driverHintsEnabled", false);
        if (string5 != null) {
            sqlMap.setDriverHintsEnabled("true".equals(string5));
        } else {
            sqlMap.setDriverHintsEnabled(false);
        }
    }

    private static void parseDataSource(SqlMap sqlMap, Element element, String string) {
        Object object;
        Object object2;
        Element element2;
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, "name", true);
        String string3 = XmlSqlMapBuilder.getAttributeValue(element, "factory-class", true);
        Properties properties = new Properties();
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            element2 = (Element)list.get(n);
            if (!PROPERTY_ELEMENT.equals(element2.getName())) {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            object2 = XmlSqlMapBuilder.getAttributeValue(element2, "name", true);
            object = XmlSqlMapBuilder.getAttributeValue(element2, "value", true);
            properties.setProperty((String)object2, (String)object);
            ++n;
        }
        try {
            element2 = Class.forName(string3);
            object2 = (DataSourceFactory)element2.newInstance();
            object2.initialize(properties);
            object = object2.getDataSource();
            sqlMap.addDataSource(string2, (DataSource)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SqlMapException("Invalid DataSourceFactory class. Cause: " + classNotFoundException, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SqlMapException("Could not instantiate DataSourceFactory. Cause: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SqlMapException("Could not access constructor for DataSourceFactory class. Cause: " + illegalAccessException, illegalAccessException);
        }
        boolean bl = "true".equals(XmlSqlMapBuilder.getAttributeValue(element, "default", false));
        if (bl) {
            if (sqlMap.getCurrentDataSource() == null) {
                sqlMap.setCurrentDataSourceName(string2);
            } else {
                throw new SqlMapException("Error.  There can be only one default Data Source for a SQL Map.");
            }
        }
    }

    private static void includeSqlMap(SqlMap sqlMap, String string, boolean bl) throws IOException, JDOMException {
        XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, new InputStreamReader(Resources.getResourceAsStream(string)), string, bl);
    }

    private static void includeSqlMap(SqlMap sqlMap, Element element, String string) {
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, "name", true);
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Object object;
            Element element2 = (Element)list.get(n);
            if (PARAMETER_MAP_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildParameterMap(element2, string2, string);
                sqlMap.addParameterMap((ParameterMap)object);
            } else if (RESULT_MAP_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildResultMap(element2, string2, string);
                sqlMap.addResultMap((ResultMap)object);
            } else if (CACHE_MODEL_ELEMENT.equals(element2.getName())) {
                if (sqlMap.isCacheModelsEnabled()) {
                    object = XmlSqlMapBuilder.buildCache(element2, string);
                    sqlMap.addCache((Cache)object);
                }
            } else if (DYNAMIC_MAPPED_STATEMENT_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildDynamicMappedStatement(element2, sqlMap, string2, string);
                if (sqlMap.isUseFullyQualifiedStatementNames()) {
                    ((MappedStatement)object).setName(string2 + DOT + ((MappedStatement)object).getName());
                }
                sqlMap.addMappedStatement((MappedStatement)object);
            } else if (MAPPED_STATEMENT_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildMappedStatement(element2, sqlMap, string2, string);
                if (sqlMap.isUseFullyQualifiedStatementNames()) {
                    ((MappedStatement)object).setName(string2 + DOT + ((MappedStatement)object).getName());
                }
                sqlMap.addMappedStatement((MappedStatement)object);
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            ++n;
        }
    }

    private static Cache buildCache(Element element, String string) {
        Cache cache = new Cache();
        cache.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        cache.setResourceName(string);
        cache.setReferenceType(XmlSqlMapBuilder.getAttributeValue(element, "reference-type", true));
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Element element2 = (Element)list.get(n);
            if (FLUSH_INTERVAL_ELEMENT.equals(element2.getName())) {
                long l = 0L;
                try {
                    String string2 = XmlSqlMapBuilder.getAttributeValue(element2, "milliseconds", false);
                    String string3 = XmlSqlMapBuilder.getAttributeValue(element2, "seconds", false);
                    String string4 = XmlSqlMapBuilder.getAttributeValue(element2, "minutes", false);
                    String string5 = XmlSqlMapBuilder.getAttributeValue(element2, "hours", false);
                    if (string2 != null) {
                        l += (long)Integer.parseInt(string2);
                    }
                    if (string3 != null) {
                        l += (long)(Integer.parseInt(string3) * 1000);
                    }
                    if (string4 != null) {
                        l += (long)(Integer.parseInt(string4) * 60 * 1000);
                    }
                    if (string5 != null) {
                        l += (long)(Integer.parseInt(string5) * 60 * 60 * 1000);
                    }
                    if (l < 1L) {
                        throw new NestedRuntimeException("A flush interval must specify one or more of milliseconds, seconds, minutes or hours.");
                    }
                    cache.setFlushInterval(l);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SqlMapException("Error building cache '" + cache.getName() + "' in '" + string + "'.  Flush interval milliseconds must be a valid long integer value.  Cause: " + numberFormatException, numberFormatException);
                }
            } else if (FLUSH_ON_EXECUTE_ELEMENT.equals(element2.getName())) {
                cache.addFlushTriggerStatement(XmlSqlMapBuilder.getAttributeValue(element2, "statement", true));
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            ++n;
        }
        return cache;
    }

    private static ParameterMap buildParameterMap(Element element, String string, String string2) {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            ParameterMapping parameterMapping;
            Element element2 = (Element)list.get(n);
            if (PROPERTY_ELEMENT.equals(element2.getName())) {
                String string3 = XmlSqlMapBuilder.getAttributeValue(element2, "name", true);
                String string4 = XmlSqlMapBuilder.getAttributeValue(element2, "type", false);
                String string5 = XmlSqlMapBuilder.getAttributeValue(element2, "null", false);
                parameterMapping = new ParameterMapping();
                parameterMapping.setPropertyName(string3);
                if (string4 != null) {
                    parameterMapping.setType(string4);
                }
                if (string5 != null) {
                    parameterMapping.setNullValue(string5);
                }
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string2);
            }
            parameterMap.addParameterMapping(parameterMapping);
            ++n;
        }
        parameterMap.setName(string + DOT + parameterMap.getName());
        return parameterMap;
    }

    private static ResultMap buildResultMap(Element element, String string, String string2) {
        ResultMap resultMap = new ResultMap();
        resultMap.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        resultMap.setClassName(XmlSqlMapBuilder.getAttributeValue(element, "class", true));
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            ResultMapping resultMapping;
            Element element2 = (Element)list.get(n);
            if (PROPERTY_ELEMENT.equals(element2.getName())) {
                String string3;
                String string4;
                String string5;
                String string6 = XmlSqlMapBuilder.getAttributeValue(element2, "name", true);
                String string7 = XmlSqlMapBuilder.getAttributeValue(element2, "column", false);
                resultMapping = new ResultMapping();
                resultMapping.setPropertyName(string6);
                resultMapping.setColumnName(string7);
                String string8 = XmlSqlMapBuilder.getAttributeValue(element2, "columnIndex", false);
                if (string8 != null && string8.length() > 0) {
                    resultMapping.setColumnIndex(new Integer(string8));
                }
                if ((string5 = XmlSqlMapBuilder.getAttributeValue(element2, MAPPED_STATEMENT_ELEMENT, false)) != null && string5.length() > 0) {
                    resultMapping.setStatementName(string5);
                }
                if ((string4 = XmlSqlMapBuilder.getAttributeValue(element2, "lazy-load", false)) != null && string4.length() > 0) {
                    resultMapping.setLazyLoad("true".equals(string4));
                } else {
                    resultMapping.setLazyLoad(true);
                }
                String string9 = XmlSqlMapBuilder.getAttributeValue(element2, "type", false);
                if (string9 != null && string9.length() > 0) {
                    resultMapping.setType(string9);
                }
                if ((string3 = XmlSqlMapBuilder.getAttributeValue(element2, "null", false)) != null && string3.length() > 0) {
                    resultMapping.setNullValue(string3);
                }
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string2);
            }
            resultMap.addResultMapping(resultMapping);
            ++n;
        }
        resultMap.setName(string + DOT + resultMap.getName());
        return resultMap;
    }

    private static DynamicMappedStatement buildDynamicMappedStatement(Element element, SqlMap sqlMap, String string, String string2) {
        String string3;
        String string4;
        DynamicMappedStatement dynamicMappedStatement = new DynamicMappedStatement();
        dynamicMappedStatement.setResourceName(string2);
        dynamicMappedStatement.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        dynamicMappedStatement.setParameterClass(XmlSqlMapBuilder.getAttributeValue(element, "parameter-class", false));
        dynamicMappedStatement.setResultClass(XmlSqlMapBuilder.getAttributeValue(element, "result-class", false));
        dynamicMappedStatement.setResultMapName(XmlSqlMapBuilder.getAttributeValue(element, RESULT_MAP_ELEMENT, false));
        dynamicMappedStatement.setStoredProcedure("true".equals(XmlSqlMapBuilder.getAttributeValue(element, "is-stored-procedure", false)));
        if (sqlMap.isCacheModelsEnabled() && (string4 = XmlSqlMapBuilder.getAttributeValue(element, CACHE_MODEL_ELEMENT, false)) != null) {
            try {
                dynamicMappedStatement.setCache(sqlMap.getCache(string4));
            }
            catch (SqlMapException sqlMapException) {
                throw new SqlMapException("Error building mapped statement '" + dynamicMappedStatement.getName() + "' in '" + string2 + "'.  Cause: " + sqlMapException.getMessage(), sqlMapException);
            }
        }
        dynamicMappedStatement.setInline(true);
        dynamicMappedStatement.addAllChildFragment(XmlSqlMapBuilder.buildFragmentList(element));
        dynamicMappedStatement.setSqlMap(sqlMap);
        if (dynamicMappedStatement.isInline()) {
            dynamicMappedStatement.setParameterMapName(string + DOT + dynamicMappedStatement.getName() + "-inline");
        }
        if ((string4 = dynamicMappedStatement.getParameterMapName()) != null && string4.indexOf(DOT) < 0) {
            dynamicMappedStatement.setParameterMapName(string + DOT + dynamicMappedStatement.getParameterMapName());
        }
        if ((string3 = dynamicMappedStatement.getResultMapName()) != null && string3.indexOf(DOT) < 0) {
            dynamicMappedStatement.setResultMapName(string + DOT + dynamicMappedStatement.getResultMapName());
        }
        return dynamicMappedStatement;
    }

    private static List buildFragmentList(Element element) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof Element) {
                DynamicFragment dynamicFragment;
                DynamicFragment dynamicFragment2;
                object = (Element)e;
                if ("dynamic".equals(object.getName())) {
                    dynamicFragment2 = new DynamicFragment();
                    dynamicFragment2.setPrepend(XmlSqlMapBuilder.getAttributeValue((Element)object, "prepend", false));
                    dynamicFragment2.addAllChildFragment(XmlSqlMapBuilder.buildFragmentList((Element)object));
                    arrayList.add(dynamicFragment2);
                    continue;
                }
                dynamicFragment2 = null;
                if ("isEqual".equals(object.getName())) {
                    dynamicFragment2 = new IsEqualFragment();
                } else if ("isNotEqual".equals(object.getName())) {
                    dynamicFragment2 = new IsNotEqualFragment();
                } else if ("isParameterPresent".equals(object.getName())) {
                    dynamicFragment2 = new IsParameterPresentFragment();
                } else if ("isNotParameterPresent".equals(object.getName())) {
                    dynamicFragment2 = new IsNotParameterPresentFragment();
                } else if ("isEmpty".equals(object.getName())) {
                    dynamicFragment2 = new IsEmptyFragment();
                } else if ("isNotEmpty".equals(object.getName())) {
                    dynamicFragment2 = new IsNotEmptyFragment();
                } else if ("isNull".equals(object.getName())) {
                    dynamicFragment2 = new IsNullFragment();
                } else if ("isNotNull".equals(object.getName())) {
                    dynamicFragment2 = new IsNotNullFragment();
                } else if ("isPropertyAvailable".equals(object.getName())) {
                    dynamicFragment2 = new IsPropertyAvailableFragment();
                } else if ("isNotPropertyAvailable".equals(object.getName())) {
                    dynamicFragment2 = new IsNotPropertyAvailableFragment();
                } else if ("isGreaterThan".equals(object.getName())) {
                    dynamicFragment2 = new IsGreaterThanFragment();
                } else if ("isGreaterEqual".equals(object.getName())) {
                    dynamicFragment2 = new IsGreaterEqualFragment();
                } else if ("isLessThan".equals(object.getName())) {
                    dynamicFragment2 = new IsLessThanFragment();
                } else if ("isLessEqual".equals(object.getName())) {
                    dynamicFragment2 = new IsLessEqualFragment();
                } else if ("iterate".equals(object.getName())) {
                    dynamicFragment2 = new IterateFragment();
                } else {
                    throw new SqlMapException("Unknown conditional tag: " + element.getName());
                }
                if (dynamicFragment2 instanceof ConditionalFragment) {
                    dynamicFragment = (ConditionalFragment)dynamicFragment2;
                    dynamicFragment.setPrepend(XmlSqlMapBuilder.getAttributeValue((Element)object, "prepend", false));
                    ((ConditionalFragment)dynamicFragment).setPropertyName(XmlSqlMapBuilder.getAttributeValue((Element)object, PROPERTY_ELEMENT, false));
                    ((ConditionalFragment)dynamicFragment).setCompareValue(XmlSqlMapBuilder.getAttributeValue((Element)object, "compareValue", false));
                    ((ConditionalFragment)dynamicFragment).setComparePropertyName(XmlSqlMapBuilder.getAttributeValue((Element)object, "compareProperty", false));
                    dynamicFragment.setSqlFragment(object.getText());
                    dynamicFragment.addAllChildFragment(XmlSqlMapBuilder.buildFragmentList((Element)object));
                } else if (dynamicFragment2 instanceof IterateFragment) {
                    dynamicFragment = (IterateFragment)dynamicFragment2;
                    dynamicFragment.setPrepend(XmlSqlMapBuilder.getAttributeValue((Element)object, "prepend", false));
                    ((IterateFragment)dynamicFragment).setPropertyName(XmlSqlMapBuilder.getAttributeValue((Element)object, PROPERTY_ELEMENT, false));
                    ((IterateFragment)dynamicFragment).setClose(XmlSqlMapBuilder.getAttributeValue((Element)object, "close", false));
                    ((IterateFragment)dynamicFragment).setOpen(XmlSqlMapBuilder.getAttributeValue((Element)object, "open", false));
                    ((IterateFragment)dynamicFragment).setConjunction(XmlSqlMapBuilder.getAttributeValue((Element)object, "conjunction", false));
                    dynamicFragment.setSqlFragment(object.getText());
                    dynamicFragment.addAllChildFragment(XmlSqlMapBuilder.buildFragmentList((Element)object));
                }
                arrayList.add(dynamicFragment2);
                continue;
            }
            if (e instanceof CDATA) {
                object = new StaticFragment();
                ((BaseFragment)object).setSqlFragment(((CDATA)e).getText());
                arrayList.add(object);
                continue;
            }
            if (!(e instanceof Text)) continue;
            object = new StaticFragment();
            ((BaseFragment)object).setSqlFragment(((Text)e).getText());
            arrayList.add(object);
        }
        return arrayList;
    }

    private static MappedStatement buildMappedStatement(Element element, SqlMap sqlMap, String string, String string2) {
        String string3;
        String string4;
        String string5;
        MappedStatement mappedStatement = new MappedStatement();
        mappedStatement.setResourceName(string2);
        mappedStatement.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        mappedStatement.setParameterMapName(XmlSqlMapBuilder.getAttributeValue(element, PARAMETER_MAP_ELEMENT, false));
        mappedStatement.setResultMapName(XmlSqlMapBuilder.getAttributeValue(element, RESULT_MAP_ELEMENT, false));
        mappedStatement.setStoredProcedure("true".equals(XmlSqlMapBuilder.getAttributeValue(element, "is-stored-procedure", false)));
        if (sqlMap.isCacheModelsEnabled() && (string5 = XmlSqlMapBuilder.getAttributeValue(element, CACHE_MODEL_ELEMENT, false)) != null) {
            try {
                mappedStatement.setCache(sqlMap.getCache(string5));
            }
            catch (SqlMapException sqlMapException) {
                throw new SqlMapException("Error building mapped statement '" + mappedStatement.getName() + "' in '" + string2 + "'.  Cause: " + sqlMapException.getMessage(), sqlMapException);
            }
        }
        mappedStatement.setParameterClass(XmlSqlMapBuilder.getAttributeValue(element, "parameter-class", false));
        mappedStatement.setResultClass(XmlSqlMapBuilder.getAttributeValue(element, "result-class", false));
        string5 = XmlSqlMapBuilder.getAttributeValue(element, "inline-parameters", false);
        if (string5 == null && mappedStatement.getParameterMapName() == null) {
            mappedStatement.setInline(true);
        } else {
            mappedStatement.setInline("true".equals(string5));
        }
        String string6 = element.getText();
        if (string6 == null || string6.trim().length() <= 0) {
            throw new SqlMapException("A mapped statement element requires body content in " + string2);
        }
        mappedStatement.setSql(string6.trim());
        mappedStatement.setSqlMap(sqlMap);
        if (mappedStatement.isInline()) {
            mappedStatement.setParameterMapName(string + DOT + mappedStatement.getName() + "-inline");
            XmlSqlMapBuilder.processInlineParameterMap(mappedStatement);
        }
        if ((string4 = mappedStatement.getParameterMapName()) != null && string4.indexOf(DOT) < 0) {
            mappedStatement.setParameterMapName(string + DOT + mappedStatement.getParameterMapName());
        }
        if ((string3 = mappedStatement.getResultMapName()) != null && string3.indexOf(DOT) < 0) {
            mappedStatement.setResultMapName(string + DOT + mappedStatement.getResultMapName());
        }
        return mappedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processInlineParameterMap(MappedStatement mappedStatement) {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.setName(mappedStatement.getParameterMapName());
        StringTokenizer stringTokenizer = new StringTokenizer(mappedStatement.getSql(null), PARAMETER_TOKEN, true);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (PARAMETER_TOKEN.equals(string2)) {
                if (PARAMETER_TOKEN.equals(string)) {
                    stringBuffer.append(PARAMETER_TOKEN);
                    string = null;
                } else {
                    Object object;
                    if (string.indexOf(58) > -1) {
                        Object object2;
                        String string3;
                        String string4;
                        object = new StringTokenizer(string, ":", true);
                        int n = ((StringTokenizer)object).countTokens();
                        if (n == 3) {
                            string4 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            string3 = ((StringTokenizer)object).nextToken();
                            object2 = new ParameterMapping();
                            ((ParameterMapping)object2).setPropertyName(string4);
                            ((ParameterMapping)object2).setType(string3);
                            parameterMap.addParameterMapping((ParameterMapping)object2);
                        } else {
                            if (n < 5) throw new SqlMapException("Incorrect inline parameter map format: " + string);
                            string4 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            string3 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            object2 = ((StringTokenizer)object).nextToken();
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                object2 = (String)object2 + ((StringTokenizer)object).nextToken();
                            }
                            ParameterMapping parameterMapping = new ParameterMapping();
                            parameterMapping.setPropertyName(string4);
                            parameterMapping.setType(string3);
                            parameterMapping.setNullValue((String)object2);
                            parameterMap.addParameterMapping(parameterMapping);
                        }
                    } else {
                        object = new ParameterMapping();
                        ((ParameterMapping)object).setPropertyName(string);
                        parameterMap.addParameterMapping((ParameterMapping)object);
                    }
                    stringBuffer.append("?");
                    string = stringTokenizer.nextToken();
                    if (!PARAMETER_TOKEN.equals(string)) {
                        throw new SqlMapException("Unterminated inline parameter in mapped statement (" + mappedStatement.getName() + ").");
                    }
                    string = null;
                }
            } else if (!PARAMETER_TOKEN.equals(string)) {
                stringBuffer.append(string);
            }
            string2 = string;
        }
        mappedStatement.setSql(stringBuffer.toString());
        mappedStatement.getSqlMap().addParameterMap(parameterMap);
    }

    private static int getAttributeValueAsInt(Element element, String string, boolean bl) {
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, string, bl);
        try {
            if (string2 != null && !"".equals(string2)) {
                return Integer.parseInt(string2);
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlMapException("Error configuring SqlMap.  The attribute named '" + string + "' must be an integer (was " + string2 + ").  Cause: " + numberFormatException, numberFormatException);
        }
    }

    private static String getAttributeValue(Element element, String string, boolean bl) {
        String string2 = null;
        Attribute attribute = element.getAttribute(string);
        if (attribute != null) {
            string2 = attribute.getValue();
        }
        if (properties != null && string2 != null && string2.startsWith("${") && string2.endsWith("}") && string2.length() > 3) {
            String string3 = string2;
            string3 = string3.substring(2);
            String string4 = properties.getProperty(string3 = string3.substring(0, string3.length() - 1));
            string2 = string4 != null ? string4 : System.getProperty(string3, string2);
        }
        if (bl && string2 == null) {
            throw new SqlMapException("Error while building SQL Map.  A '" + element.getName() + "' element requires a '" + string + "' attribute.");
        }
        return string2;
    }

    static {
        validationEnabled = true;
    }
}

