/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import java.sql.SQLException;
import java.util.HashMap;

public class TypeRegistry {
    public static final int UNKNOWN_TYPE = -99999;
    private static final HashMap typeMap = new HashMap();

    private static void setType(String string, int n) {
        typeMap.put(string, new Integer(n));
    }

    public static int getType(String string) throws SQLException {
        if (string != null) {
            Integer n = (Integer)typeMap.get(string);
            if (n == null) {
                throw new SQLException("Unkown type was not found for type-name '" + string + "'");
            }
            return n;
        }
        return -99999;
    }

    private static void initializeTypes() {
        TypeRegistry.setType("ARRAY", 2003);
        TypeRegistry.setType("BIGINT", -5);
        TypeRegistry.setType("BINARY", -2);
        TypeRegistry.setType("BIT", -7);
        TypeRegistry.setType("BLOB", 2004);
        TypeRegistry.setType("CHAR", 1);
        TypeRegistry.setType("CLOB", 2005);
        TypeRegistry.setType("DATE", 91);
        TypeRegistry.setType("DECIMAL", 3);
        TypeRegistry.setType("DISTINCT", 2001);
        TypeRegistry.setType("DOUBLE", 8);
        TypeRegistry.setType("FLOAT", 6);
        TypeRegistry.setType("INTEGER", 4);
        TypeRegistry.setType("JAVA_OBJECT", 2000);
        TypeRegistry.setType("LONGVARBINARY", -4);
        TypeRegistry.setType("LONGVARCHAR", -1);
        TypeRegistry.setType("NULL", 0);
        TypeRegistry.setType("NUMERIC", 2);
        TypeRegistry.setType("OTHER", 1111);
        TypeRegistry.setType("REAL", 7);
        TypeRegistry.setType("REF", 2006);
        TypeRegistry.setType("SMALLINT", 5);
        TypeRegistry.setType("STRUCT", 2002);
        TypeRegistry.setType("TIME", 92);
        TypeRegistry.setType("TIMESTAMP", 93);
        TypeRegistry.setType("TINYINT", -6);
        TypeRegistry.setType("VARBINARY", -3);
        TypeRegistry.setType("VARCHAR", 12);
    }

    static {
        TypeRegistry.initializeTypes();
    }
}

