/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatementFactory {
    private Object CACHE_LOCK = new Object();
    private List allAvailableStatements = new ArrayList();
    private int maxTotalCachedStatements = 0;
    private Map availableStatementMap = new HashMap();
    private Map busyStatementMap = new HashMap();
    private int cacheRequests = 0;
    private int cacheHits = 0;

    public int getMaxTotalCachedStatements() {
        return this.maxTotalCachedStatements;
    }

    public void setMaxTotalCachedStatements(int n) {
        this.maxTotalCachedStatements = n;
    }

    public Double getCacheHitRatio() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            if (this.cacheRequests != 0) {
                Double d = new Double((double)this.cacheHits / (double)this.cacheRequests);
                return d;
            }
            Double d = null;
            return d;
        }
    }

    public PreparedStatement newStatement(Connection connection, String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        if (bl) {
            StatementWrapper statementWrapper = new StatementWrapper(connection, string, preparedStatement);
            this.busyStatementMap.put(preparedStatement, statementWrapper);
        }
        return preparedStatement;
    }

    public CallableStatement newCallable(Connection connection, String string, boolean bl) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall(string);
        if (bl) {
            StatementWrapper statementWrapper = new StatementWrapper(connection, string, callableStatement);
            this.busyStatementMap.put(callableStatement, statementWrapper);
        }
        return callableStatement;
    }

    public PreparedStatement getStatement(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        StatementWrapper statementWrapper = null;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            List list;
            ++this.cacheRequests;
            Map map = (Map)this.availableStatementMap.get(connection);
            if (map != null && (list = (List)map.get(string)) != null && list.size() > 1) {
                statementWrapper = null;
                while (statementWrapper == null && list.size() > 0) {
                    statementWrapper = (StatementWrapper)list.remove(0);
                    this.allAvailableStatements.remove(statementWrapper);
                    try {
                        statementWrapper.ps.clearParameters();
                    }
                    catch (Exception exception) {
                        statementWrapper = null;
                    }
                }
            }
            if (statementWrapper != null) {
                ++this.cacheHits;
                this.busyStatementMap.put(statementWrapper.ps, statementWrapper);
                preparedStatement = statementWrapper.ps;
            } else {
                preparedStatement = null;
            }
        }
        return preparedStatement;
    }

    public void releaseStatement(PreparedStatement preparedStatement) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            StatementWrapper statementWrapper = (StatementWrapper)this.busyStatementMap.remove(preparedStatement);
            if (statementWrapper != null) {
                if (this.maxTotalCachedStatements > 0) {
                    ArrayList<StatementWrapper> arrayList;
                    HashMap hashMap = (HashMap)this.availableStatementMap.get(statementWrapper.connection);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        this.availableStatementMap.put(statementWrapper.connection, hashMap);
                    }
                    if ((arrayList = (ArrayList<StatementWrapper>)hashMap.get(statementWrapper.sql)) == null) {
                        arrayList = new ArrayList<StatementWrapper>();
                        hashMap.put(statementWrapper.sql, arrayList);
                    }
                    if (this.allAvailableStatements.size() > 0 && this.allAvailableStatements.size() >= this.maxTotalCachedStatements) {
                        StatementWrapper statementWrapper2 = (StatementWrapper)this.allAvailableStatements.remove(0);
                        StatementFactory.forceCloseStatement(statementWrapper2.ps);
                    }
                    arrayList.add(statementWrapper);
                    this.allAvailableStatements.add(statementWrapper);
                } else {
                    StatementFactory.forceCloseStatement(preparedStatement);
                }
            } else {
                StatementFactory.forceCloseStatement(preparedStatement);
            }
        }
    }

    private static void forceCloseStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class StatementWrapper {
        public Connection connection;
        public String sql;
        public PreparedStatement ps;

        public StatementWrapper(Connection connection, String string, PreparedStatement preparedStatement) throws SQLException {
            this.connection = connection;
            this.sql = string;
            this.ps = preparedStatement;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof StatementWrapper)) {
                return false;
            }
            StatementWrapper statementWrapper = (StatementWrapper)object;
            if (!this.connection.equals(statementWrapper.connection)) {
                return false;
            }
            if (!this.ps.equals(statementWrapper.ps)) {
                return false;
            }
            return this.sql.equals(statementWrapper.sql);
        }

        public int hashCode() {
            int n = this.connection.hashCode();
            n = 29 * n + this.sql.hashCode();
            n = 29 * n + this.ps.hashCode();
            return n;
        }

        public String toString() {
            return this.sql;
        }
    }
}

