/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.db.sqlmap.ExecuteListener;
import com.ibatis.db.sqlmap.MappedStatement;
import com.ibatis.db.sqlmap.SqlMapException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Cache
implements ExecuteListener {
    public static final String REF_TYPE_STRONG = "STRONG";
    public static final String REF_TYPE_SOFT = "SOFT";
    public static final String REF_TYPE_WEAK = "WEAK";
    private static final long NO_FLUSH_INTERVAL = -1L;
    private String name;
    private String resourceName;
    private long lastFlush = System.currentTimeMillis();
    private String referenceType = "WEAK";
    private Set flushTriggerStatements = new HashSet();
    private long flushInterval = -1L;
    private HashMap cacheTable = new HashMap();
    private static final Object STATS_LOCK = new Object();
    private int requests = 0;
    private int hits = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public void flush() {
        HashMap hashMap = this.cacheTable;
        synchronized (hashMap) {
            this.cacheTable.clear();
            this.lastFlush = System.currentTimeMillis();
        }
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String string) {
        if (string == null || !string.equals(REF_TYPE_WEAK) && !string.equals(REF_TYPE_SOFT) && !string.equals(REF_TYPE_STRONG)) {
            throw new SqlMapException("Unknown reference type '" + string + "' set in Cache.");
        }
        this.referenceType = string;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(long l) {
        this.flushInterval = l;
    }

    public void put(Object object, Object object2) {
        Object object3 = null;
        if (this.referenceType.equals(REF_TYPE_WEAK)) {
            object3 = new WeakReference<Object>(object2);
        } else if (this.referenceType.equals(REF_TYPE_SOFT)) {
            object3 = new SoftReference<Object>(object2);
        } else if (this.referenceType.equals(REF_TYPE_STRONG)) {
            object3 = new StrongReference(object2);
        } else {
            throw new NestedRuntimeException("Unknown reference '" + this.referenceType + "' type set in Cache.");
        }
        HashMap hashMap = this.cacheTable;
        synchronized (hashMap) {
            this.cacheTable.put(object, object3);
        }
    }

    public Object get(Object object) {
        Object object2 = STATS_LOCK;
        synchronized (object2) {
            ++this.requests;
        }
        if (this.flushInterval != -1L && System.currentTimeMillis() - this.lastFlush > this.flushInterval) {
            this.flush();
        }
        Object object3 = null;
        Object var4_5 = null;
        HashMap hashMap = this.cacheTable;
        synchronized (hashMap) {
            var4_5 = this.cacheTable.get(object);
        }
        if (var4_5 != null) {
            Object object4 = STATS_LOCK;
            synchronized (object4) {
                ++this.hits;
            }
            if (var4_5 instanceof StrongReference) {
                object3 = ((StrongReference)var4_5).get();
            } else if (var4_5 instanceof SoftReference) {
                object3 = ((SoftReference)var4_5).get();
            } else if (var4_5 instanceof WeakReference) {
                object3 = ((WeakReference)var4_5).get();
            }
        }
        return object3;
    }

    public double getHitRatio() {
        Object object = STATS_LOCK;
        synchronized (object) {
            double d = (double)this.hits / (double)this.requests;
            return d;
        }
    }

    public void addFlushTriggerStatement(String string) {
        this.flushTriggerStatements.add(string);
    }

    public Iterator getFlushTriggerStatements() {
        return this.flushTriggerStatements.iterator();
    }

    public void onExecuteStatement(MappedStatement mappedStatement) {
        this.flush();
    }

    private static class StrongReference {
        private Object object;

        public StrongReference(Object object) {
            this.object = object;
        }

        public Object get() {
            return this.object;
        }
    }
}

