/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.jdbc;

import com.ibatis.common.exception.NestedRuntimeException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleDataSource
implements DataSource {
    private static final Log log = LogFactory.getLog((Class)(class$com$ibatis$db$jdbc$SimpleDataSource == null ? (class$com$ibatis$db$jdbc$SimpleDataSource = SimpleDataSource.class$("com.ibatis.db.jdbc.SimpleDataSource")) : class$com$ibatis$db$jdbc$SimpleDataSource));
    private static final String PROP_JDBC_DRIVER = "JDBC.Driver";
    private static final String PROP_JDBC_URL = "JDBC.ConnectionURL";
    private static final String PROP_JDBC_USERNAME = "JDBC.Username";
    private static final String PROP_JDBC_PASSWORD = "JDBC.Password";
    private static final String PROP_POOL_MAX_ACTIVE_CONN = "Pool.MaximumActiveConnections";
    private static final String PROP_POOL_MAX_IDLE_CONN = "Pool.MaximumIdleConnections";
    private static final String PROP_POOL_MAX_CHECKOUT_TIME = "Pool.MaximumCheckoutTime";
    private static final String PROP_POOL_TIME_TO_WAIT = "Pool.TimeToWait";
    private static final String PROP_POOL_PING_QUERY = "Pool.PingQuery";
    private static final String PROP_POOL_PING_CONN_OLDER_THAN = "Pool.PingConnectionsOlderThan";
    private static final String PROP_POOL_PING_ENABLED = "Pool.PingEnabled";
    private static final String PROP_POOL_QUIET_MODE = "Pool.QuietMode";
    private static final String PROP_POOL_PING_CONN_NOT_USED_FOR = "Pool.PingConnectionsNotUsedFor";
    private int expectedConnectionTypeCode;
    private static final String ADD_DRIVER_PROPS_PREFIX = "Driver.";
    private static final int ADD_DRIVER_PROPS_PREFIX_LENGTH = "Driver.".length();
    private static final Object POOL_LOCK = new Object();
    private List idleConnections = new ArrayList();
    private List activeConnections = new ArrayList();
    private long requestCount = 0L;
    private long accumulatedRequestTime = 0L;
    private long accumulatedCheckoutTime = 0L;
    private long claimedOverdueConnectionCount = 0L;
    private long accumulatedCheckoutTimeOfOverdueConnections = 0L;
    private long accumulatedWaitTime = 0L;
    private long hadToWaitCount = 0L;
    private long badConnectionCount = 0L;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUsername;
    private String jdbcPassword;
    private Properties driverProps;
    private boolean useDriverProps;
    private int poolMaximumActiveConnections;
    private int poolMaximumIdleConnections;
    private int poolMaximumCheckoutTime;
    private int poolTimeToWait;
    private String poolPingQuery;
    private boolean poolQuietMode;
    private boolean poolPingEnabled;
    private int poolPingConnectionsOlderThan;
    private int poolPingConnectionsNotUsedFor;
    static /* synthetic */ Class class$com$ibatis$db$jdbc$SimpleDataSource;

    public SimpleDataSource(Map map) {
        this.initialize(map);
    }

    private void initialize(Map map) {
        try {
            if (map == null) {
                throw new NestedRuntimeException("SimpleDataSource: The properties map passed to the initializer was null.");
            }
            if (!(map.containsKey(PROP_JDBC_DRIVER) && map.containsKey(PROP_JDBC_URL) && map.containsKey(PROP_JDBC_USERNAME) && map.containsKey(PROP_JDBC_PASSWORD))) {
                throw new NestedRuntimeException("SimpleDataSource: Some properties were not set.");
            }
            this.jdbcDriver = (String)map.get(PROP_JDBC_DRIVER);
            this.jdbcUrl = (String)map.get(PROP_JDBC_URL);
            this.jdbcUsername = (String)map.get(PROP_JDBC_USERNAME);
            this.jdbcPassword = (String)map.get(PROP_JDBC_PASSWORD);
            this.poolMaximumActiveConnections = map.containsKey(PROP_POOL_MAX_ACTIVE_CONN) ? Integer.parseInt((String)map.get(PROP_POOL_MAX_ACTIVE_CONN)) : 10;
            this.poolMaximumIdleConnections = map.containsKey(PROP_POOL_MAX_IDLE_CONN) ? Integer.parseInt((String)map.get(PROP_POOL_MAX_IDLE_CONN)) : 5;
            this.poolMaximumCheckoutTime = map.containsKey(PROP_POOL_MAX_CHECKOUT_TIME) ? Integer.parseInt((String)map.get(PROP_POOL_MAX_CHECKOUT_TIME)) : 20000;
            this.poolTimeToWait = map.containsKey(PROP_POOL_TIME_TO_WAIT) ? Integer.parseInt((String)map.get(PROP_POOL_TIME_TO_WAIT)) : 20000;
            this.poolPingEnabled = map.containsKey(PROP_POOL_PING_ENABLED) ? Boolean.valueOf((String)map.get(PROP_POOL_PING_ENABLED)) : false;
            this.poolPingQuery = map.containsKey(PROP_POOL_PING_QUERY) ? (String)map.get(PROP_POOL_PING_QUERY) : "NO PING QUERY SET";
            this.poolPingConnectionsOlderThan = map.containsKey(PROP_POOL_PING_CONN_OLDER_THAN) ? Integer.parseInt((String)map.get(PROP_POOL_PING_CONN_OLDER_THAN)) : 0;
            this.poolPingConnectionsNotUsedFor = map.containsKey(PROP_POOL_PING_CONN_NOT_USED_FOR) ? Integer.parseInt((String)map.get(PROP_POOL_PING_CONN_NOT_USED_FOR)) : 0;
            this.poolQuietMode = map.containsKey(PROP_POOL_QUIET_MODE) ? Boolean.valueOf((String)map.get(PROP_POOL_QUIET_MODE)) : true;
            this.useDriverProps = false;
            Iterator iterator = map.keySet().iterator();
            this.driverProps = new Properties();
            ((Hashtable)this.driverProps).put("user", this.jdbcUsername);
            ((Hashtable)this.driverProps).put("password", this.jdbcPassword);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                if (!string.startsWith(ADD_DRIVER_PROPS_PREFIX)) continue;
                ((Hashtable)this.driverProps).put(string.substring(ADD_DRIVER_PROPS_PREFIX_LENGTH), string2);
                this.useDriverProps = true;
            }
            this.expectedConnectionTypeCode = this.assembleConnectionTypeCode(this.jdbcUrl, this.jdbcUsername, this.jdbcPassword);
            Class.forName(this.jdbcDriver).newInstance();
        }
        catch (Exception exception) {
            log.error((Object)("SimpleDataSource: Error while loading properties. Cause: " + exception.toString()), (Throwable)exception);
            throw new NestedRuntimeException("SimpleDataSource: Error while loading properties. Cause: " + exception, exception);
        }
    }

    private int assembleConnectionTypeCode(String string, String string2, String string3) {
        return ("" + string + string2 + string3).hashCode();
    }

    public Connection getConnection() throws SQLException {
        return this.popConnection(this.jdbcUsername, this.jdbcPassword);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.popConnection(string, string2);
    }

    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        DriverManager.setLogWriter(printWriter);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public int getPoolPingConnectionsNotUsedFor() {
        return this.poolPingConnectionsNotUsedFor;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public int getPoolMaximumActiveConnections() {
        return this.poolMaximumActiveConnections;
    }

    public int getPoolMaximumIdleConnections() {
        return this.poolMaximumIdleConnections;
    }

    public int getPoolMaximumCheckoutTime() {
        return this.poolMaximumCheckoutTime;
    }

    public int getPoolTimeToWait() {
        return this.poolTimeToWait;
    }

    public String getPoolPingQuery() {
        return this.poolPingQuery;
    }

    public boolean isPoolPingEnabled() {
        return this.poolPingEnabled;
    }

    public int getPoolPingConnectionsOlderThan() {
        return this.poolPingConnectionsOlderThan;
    }

    public boolean isPoolQuietMode() {
        return this.poolQuietMode;
    }

    private void log(Object object) {
        if (!this.isPoolQuietMode() && log.isDebugEnabled()) {
            log.debug(object);
        }
    }

    public void setPoolQuietMode(boolean bl) {
        this.poolQuietMode = bl;
    }

    private int getExpectedConnectionTypeCode() {
        return this.expectedConnectionTypeCode;
    }

    public long getRequestCount() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.requestCount;
            return l;
        }
    }

    public long getAverageRequestTime() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.requestCount == 0L ? 0L : this.accumulatedRequestTime / this.requestCount;
            return l;
        }
    }

    public long getAverageWaitTime() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.hadToWaitCount == 0L ? 0L : this.accumulatedWaitTime / this.hadToWaitCount;
            return l;
        }
    }

    public long getHadToWaitCount() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.hadToWaitCount;
            return l;
        }
    }

    public long getBadConnectionCount() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.badConnectionCount;
            return l;
        }
    }

    public long getClaimedOverdueConnectionCount() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.claimedOverdueConnectionCount;
            return l;
        }
    }

    public long getAverageOverdueCheckoutTime() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.claimedOverdueConnectionCount == 0L ? 0L : this.accumulatedCheckoutTimeOfOverdueConnections / this.claimedOverdueConnectionCount;
            return l;
        }
    }

    public long getAverageCheckoutTime() {
        Object object = POOL_LOCK;
        synchronized (object) {
            long l = this.requestCount == 0L ? 0L : this.accumulatedCheckoutTime / this.requestCount;
            return l;
        }
    }

    public String getStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n===============================================================");
        stringBuffer.append("\n jdbcDriver                     " + this.jdbcDriver);
        stringBuffer.append("\n jdbcUrl                        " + this.jdbcUrl);
        stringBuffer.append("\n jdbcUsername                   " + this.jdbcUsername);
        stringBuffer.append("\n jdbcPassword                   " + (this.jdbcPassword == null ? "NULL" : "************"));
        stringBuffer.append("\n poolMaxActiveConnections       " + this.poolMaximumActiveConnections);
        stringBuffer.append("\n poolMaxIdleConnections         " + this.poolMaximumIdleConnections);
        stringBuffer.append("\n poolMaxCheckoutTime            " + this.poolMaximumCheckoutTime);
        stringBuffer.append("\n poolTimeToWait                 " + this.poolTimeToWait);
        stringBuffer.append("\n poolQuietMode                  " + this.poolQuietMode);
        stringBuffer.append("\n poolPingEnabled                " + this.poolPingEnabled);
        stringBuffer.append("\n poolPingQuery                  " + this.poolPingQuery);
        stringBuffer.append("\n poolPingConnectionsOlderThan   " + this.poolPingConnectionsOlderThan);
        stringBuffer.append("\n poolPingConnectionsNotUsedFor  " + this.poolPingConnectionsNotUsedFor);
        stringBuffer.append("\n --------------------------------------------------------------");
        stringBuffer.append("\n activeConnections              " + this.activeConnections.size());
        stringBuffer.append("\n idleConnections                " + this.idleConnections.size());
        stringBuffer.append("\n requestCount                   " + this.getRequestCount());
        stringBuffer.append("\n averageRequestTime             " + this.getAverageRequestTime());
        stringBuffer.append("\n averageCheckoutTime            " + this.getAverageCheckoutTime());
        stringBuffer.append("\n claimedOverdue                 " + this.getClaimedOverdueConnectionCount());
        stringBuffer.append("\n averageOverdueCheckoutTime     " + this.getAverageOverdueCheckoutTime());
        stringBuffer.append("\n hadToWait                      " + this.getHadToWaitCount());
        stringBuffer.append("\n averageWaitTime                " + this.getAverageWaitTime());
        stringBuffer.append("\n badConnectionCount             " + this.getBadConnectionCount());
        stringBuffer.append("\n===============================================================");
        return stringBuffer.toString();
    }

    public void forceCloseAll() throws SQLException {
        Object object = POOL_LOCK;
        synchronized (object) {
            Connection connection;
            int n = this.activeConnections.size();
            while (n > 0) {
                SimplePooledConnection simplePooledConnection = (SimplePooledConnection)this.activeConnections.remove(n - 1);
                connection = simplePooledConnection.getRealConnection();
                simplePooledConnection.invalidate();
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
                connection.close();
                --n;
            }
            int n2 = this.idleConnections.size();
            while (n2 > 0) {
                connection = (SimplePooledConnection)this.idleConnections.remove(n2 - 1);
                Connection connection2 = ((SimplePooledConnection)connection).getRealConnection();
                ((SimplePooledConnection)connection).invalidate();
                if (!connection2.getAutoCommit()) {
                    connection2.rollback();
                }
                connection2.close();
                --n2;
            }
        }
        this.log("Forcefully closed all connections.");
    }

    private void pushConnection(SimplePooledConnection simplePooledConnection) throws SQLException {
        Object object = POOL_LOCK;
        synchronized (object) {
            this.activeConnections.remove(simplePooledConnection);
            if (simplePooledConnection.isValid()) {
                if (this.idleConnections.size() < this.poolMaximumIdleConnections && simplePooledConnection.getConnectionTypeCode() == this.getExpectedConnectionTypeCode()) {
                    this.accumulatedCheckoutTime += simplePooledConnection.getCheckoutTime();
                    if (!simplePooledConnection.getRealConnection().getAutoCommit()) {
                        simplePooledConnection.getRealConnection().rollback();
                    }
                    SimplePooledConnection simplePooledConnection2 = new SimplePooledConnection(simplePooledConnection.getRealConnection(), this);
                    this.idleConnections.add(simplePooledConnection2);
                    simplePooledConnection2.setCreatedTimestamp(simplePooledConnection.getCreatedTimestamp());
                    simplePooledConnection2.setLastUsedTimestamp(simplePooledConnection.getLastUsedTimestamp());
                    simplePooledConnection.invalidate();
                    this.log("Returned connection " + simplePooledConnection2.getRealHashCode() + " to pool.");
                    POOL_LOCK.notifyAll();
                } else {
                    this.accumulatedCheckoutTime += simplePooledConnection.getCheckoutTime();
                    if (!simplePooledConnection.getRealConnection().getAutoCommit()) {
                        simplePooledConnection.getRealConnection().rollback();
                    }
                    simplePooledConnection.getRealConnection().close();
                    this.log("Closed connection " + simplePooledConnection.getRealHashCode() + ".");
                    simplePooledConnection.invalidate();
                }
            } else {
                this.log("A bad connection (" + simplePooledConnection.getRealHashCode() + ") attempted to return to the pool, discarding connection.");
                ++this.badConnectionCount;
            }
        }
    }

    private SimplePooledConnection popConnection(String string, String string2) throws SQLException {
        boolean bl = false;
        SimplePooledConnection simplePooledConnection = null;
        long l = System.currentTimeMillis();
        int n = 0;
        while (simplePooledConnection == null) {
            Object object = POOL_LOCK;
            synchronized (object) {
                if (this.idleConnections.size() > 0) {
                    simplePooledConnection = (SimplePooledConnection)this.idleConnections.remove(0);
                    this.log("Checked out connection " + simplePooledConnection.getRealHashCode() + " from pool.");
                } else if (this.activeConnections.size() < this.poolMaximumActiveConnections) {
                    simplePooledConnection = this.useDriverProps ? new SimplePooledConnection(DriverManager.getConnection(this.jdbcUrl, this.driverProps), this) : new SimplePooledConnection(DriverManager.getConnection(this.jdbcUrl, this.jdbcUsername, this.jdbcPassword), this);
                    this.log("Created connection " + simplePooledConnection.getRealHashCode() + ".");
                } else {
                    SimplePooledConnection simplePooledConnection2 = (SimplePooledConnection)this.activeConnections.get(0);
                    long l2 = simplePooledConnection2.getCheckoutTime();
                    if (l2 > (long)this.poolMaximumCheckoutTime) {
                        ++this.claimedOverdueConnectionCount;
                        this.accumulatedCheckoutTimeOfOverdueConnections += l2;
                        this.accumulatedCheckoutTime += l2;
                        this.activeConnections.remove(simplePooledConnection2);
                        if (!simplePooledConnection2.getRealConnection().getAutoCommit()) {
                            simplePooledConnection2.getRealConnection().rollback();
                        }
                        simplePooledConnection = new SimplePooledConnection(simplePooledConnection2.getRealConnection(), this);
                        simplePooledConnection2.invalidate();
                        this.log("Claimed overdue connection " + simplePooledConnection.getRealHashCode() + ".");
                    } else {
                        try {
                            if (!bl) {
                                ++this.hadToWaitCount;
                                bl = true;
                            }
                            this.log("Waiting as long as " + this.poolTimeToWait + " milliseconds for connection.");
                            long l3 = System.currentTimeMillis();
                            POOL_LOCK.wait(this.poolTimeToWait);
                            this.accumulatedWaitTime += System.currentTimeMillis() - l3;
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
                if (simplePooledConnection != null) {
                    if (simplePooledConnection.isValid()) {
                        if (!simplePooledConnection.getRealConnection().getAutoCommit()) {
                            simplePooledConnection.getRealConnection().rollback();
                        }
                        simplePooledConnection.setConnectionTypeCode(this.assembleConnectionTypeCode(this.jdbcUrl, string, string2));
                        simplePooledConnection.setCheckoutTimestamp(System.currentTimeMillis());
                        simplePooledConnection.setLastUsedTimestamp(System.currentTimeMillis());
                        this.activeConnections.add(simplePooledConnection);
                        ++this.requestCount;
                        this.accumulatedRequestTime += System.currentTimeMillis() - l;
                    } else {
                        this.log("A bad connection (" + simplePooledConnection.getRealHashCode() + ") was returned from the pool, getting another connection.");
                        ++this.badConnectionCount;
                        simplePooledConnection = null;
                        if (++n > this.poolMaximumIdleConnections + 3) {
                            this.log("SimpleDataSource: Could not get a good connection to the database.");
                            throw new SQLException("SimpleDataSource: Could not get a good connection to the database.");
                        }
                    }
                }
            }
        }
        if (simplePooledConnection == null) {
            this.log("SimpleDataSource: Unknown severe error condition.  The connection pool returned a null connection.");
            throw new SQLException("SimpleDataSource: Unknown severe error condition.  The connection pool returned a null connection.");
        }
        return simplePooledConnection;
    }

    private boolean pingConnection(SimplePooledConnection simplePooledConnection) {
        boolean bl = true;
        try {
            bl = !simplePooledConnection.getRealConnection().isClosed();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        if (bl && this.poolPingEnabled && (this.poolPingConnectionsOlderThan > 0 && simplePooledConnection.getAge() > (long)this.poolPingConnectionsOlderThan || this.poolPingConnectionsNotUsedFor > 0 && simplePooledConnection.getTimeElapsedSinceLastUse() > (long)this.poolPingConnectionsNotUsedFor)) {
            try {
                this.log("Testing connection " + simplePooledConnection.getRealHashCode() + "...");
                Statement statement = simplePooledConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(this.poolPingQuery);
                resultSet.close();
                statement.close();
                if (!simplePooledConnection.getAutoCommit()) {
                    simplePooledConnection.rollback();
                }
                bl = true;
                this.log("Connection " + simplePooledConnection.getRealHashCode() + " is GOOD!");
            }
            catch (Exception exception) {
                try {
                    simplePooledConnection.getRealConnection().close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                bl = false;
                this.log("Connection " + simplePooledConnection.getRealHashCode() + " is BAD!");
            }
        }
        return bl;
    }

    public static Connection unwrapConnection(Connection connection) {
        if (connection instanceof SimplePooledConnection) {
            return ((SimplePooledConnection)connection).getRealConnection();
        }
        return connection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SimplePooledConnection
    implements Connection {
        private int hashCode = 0;
        private SimpleDataSource dataSource;
        private Connection realConnection;
        private long checkoutTimestamp;
        private long createdTimestamp;
        private long lastUsedTimestamp;
        private int connectionTypeCode;
        private boolean valid;

        public SimplePooledConnection(Connection connection, SimpleDataSource simpleDataSource) {
            this.hashCode = connection.hashCode();
            this.realConnection = connection;
            this.dataSource = simpleDataSource;
            this.createdTimestamp = System.currentTimeMillis();
            this.lastUsedTimestamp = System.currentTimeMillis();
            this.valid = true;
        }

        public void invalidate() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid && this.realConnection != null && this.dataSource.pingConnection(this);
        }

        public Connection getRealConnection() {
            return this.realConnection;
        }

        public int getRealHashCode() {
            if (this.realConnection == null) {
                return 0;
            }
            return this.realConnection.hashCode();
        }

        public int getConnectionTypeCode() {
            return this.connectionTypeCode;
        }

        public void setConnectionTypeCode(int n) {
            this.connectionTypeCode = n;
        }

        public long getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public void setCreatedTimestamp(long l) {
            this.createdTimestamp = l;
        }

        public long getLastUsedTimestamp() {
            return this.lastUsedTimestamp;
        }

        public void setLastUsedTimestamp(long l) {
            this.lastUsedTimestamp = l;
        }

        public long getTimeElapsedSinceLastUse() {
            return System.currentTimeMillis() - this.lastUsedTimestamp;
        }

        public long getAge() {
            return System.currentTimeMillis() - this.createdTimestamp;
        }

        public long getCheckoutTimestamp() {
            return this.checkoutTimestamp;
        }

        public void setCheckoutTimestamp(long l) {
            this.checkoutTimestamp = l;
        }

        public long getCheckoutTime() {
            return System.currentTimeMillis() - this.checkoutTimestamp;
        }

        private Connection getValidConnection() {
            if (!this.valid) {
                throw new NestedRuntimeException("Error accessing SimplePooledConnection.  Connection has been invalidated (probably released back to the pool).");
            }
            return this.realConnection;
        }

        public Statement createStatement() throws SQLException {
            return this.getValidConnection().createStatement();
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            return this.getValidConnection().prepareStatement(string);
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            return this.getValidConnection().prepareCall(string);
        }

        public String nativeSQL(String string) throws SQLException {
            return this.getValidConnection().nativeSQL(string);
        }

        public void setAutoCommit(boolean bl) throws SQLException {
            this.getValidConnection().setAutoCommit(bl);
        }

        public boolean getAutoCommit() throws SQLException {
            return this.getValidConnection().getAutoCommit();
        }

        public void commit() throws SQLException {
            this.getValidConnection().commit();
        }

        public void rollback() throws SQLException {
            this.getValidConnection().rollback();
        }

        public void close() throws SQLException {
            this.dataSource.pushConnection(this);
        }

        public boolean isClosed() throws SQLException {
            return this.getValidConnection().isClosed();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return this.getValidConnection().getMetaData();
        }

        public void setReadOnly(boolean bl) throws SQLException {
            this.getValidConnection().setReadOnly(bl);
        }

        public boolean isReadOnly() throws SQLException {
            return this.getValidConnection().isReadOnly();
        }

        public void setCatalog(String string) throws SQLException {
            this.getValidConnection().setCatalog(string);
        }

        public String getCatalog() throws SQLException {
            return this.getValidConnection().getCatalog();
        }

        public void setTransactionIsolation(int n) throws SQLException {
            this.getValidConnection().setTransactionIsolation(n);
        }

        public int getTransactionIsolation() throws SQLException {
            return this.getValidConnection().getTransactionIsolation();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.getValidConnection().getWarnings();
        }

        public void clearWarnings() throws SQLException {
            this.getValidConnection().clearWarnings();
        }

        public Statement createStatement(int n, int n2) throws SQLException {
            return this.getValidConnection().createStatement(n, n2);
        }

        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            return this.getValidConnection().prepareCall(string, n, n2);
        }

        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            return this.getValidConnection().prepareCall(string, n, n2);
        }

        public Map getTypeMap() throws SQLException {
            return this.getValidConnection().getTypeMap();
        }

        public void setTypeMap(Map map) throws SQLException {
            this.getValidConnection().setTypeMap(map);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof SimplePooledConnection) {
                return this.realConnection.hashCode() == ((SimplePooledConnection)object).realConnection.hashCode();
            }
            if (object instanceof Connection) {
                return this.hashCode == object.hashCode();
            }
            return false;
        }
    }
}

