/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao.jdbc;

import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoTransaction;
import com.ibatis.db.dao.DaoTransactionPool;
import com.ibatis.db.dao.jdbc.JdbcDaoTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JndiDataSourceDaoTransactionPool
implements DaoTransactionPool {
    private DataSource dataSource;

    public void configure(Map map) throws DaoException {
        try {
            InitialContext initialContext = new InitialContext();
            if (map.containsKey("DBFullJndiContext")) {
                this.dataSource = (DataSource)initialContext.lookup((String)map.get("DBFullJndiContext"));
            } else {
                Context context = (Context)initialContext.lookup((String)map.get("DBInitialContext"));
                this.dataSource = (DataSource)context.lookup((String)map.get("DBLookup"));
            }
        }
        catch (NamingException namingException) {
            throw new DaoException("There was an error configuring JndiDataSourceDaoTransactionPool. Cause:" + namingException, namingException);
        }
    }

    public void releaseTransaction(DaoTransaction daoTransaction) throws DaoException {
        if (this.dataSource == null) {
            throw new DaoException("DataSource is null in JdbcDaoTransactionPool (check the data source configuration).");
        }
        try {
            ((JdbcDaoTransaction)daoTransaction).getConnection().close();
        }
        catch (SQLException sQLException) {
            throw new DaoException("Error releasing DAO transaction.  Cause: " + sQLException, sQLException);
        }
    }

    public DaoTransaction getTransaction() throws DaoException {
        if (this.dataSource == null) {
            throw new DaoException("DataSource is null in JdbcDaoTransactionPool (check the data source configuration).");
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            return new JdbcDaoTransaction(this, connection);
        }
        catch (SQLException sQLException) {
            throw new DaoException("Error getting DAO transaction.  Cause: " + sQLException, sQLException);
        }
    }
}

