/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao;

import com.ibatis.common.resources.Resources;
import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoJarEntityResolver;
import com.ibatis.db.dao.DaoManager;
import com.ibatis.db.dao.DaoTransactionPool;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class XmlDaoManagerBuilder {
    private static final String DAO_CONFIG_ELEMENT = "dao-config";
    private static final String CONTEXT_ELEMENT = "context";
    private static final String TRANS_POOL_ELEMENT = "transaction-pool";
    private static final String DAO_FACTORY_ELEMENT = "dao-factory";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String EXTRA_PROPS_ELEMENT = "extra-properties";
    private static final String DAO_ELEMENT = "dao";
    private static Properties properties = null;
    private static boolean validationEnabled = true;

    public static DaoManager[] buildDaoManagers(Reader reader) throws DaoException {
        ArrayList<DaoManager> arrayList = new ArrayList<DaoManager>();
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            sAXBuilder.setEntityResolver((EntityResolver)new DaoJarEntityResolver());
            sAXBuilder.setValidation(validationEnabled);
            Document document = sAXBuilder.build(reader);
            Element element = document.getRootElement();
            String string = element.getName();
            if (!DAO_CONFIG_ELEMENT.equals(string)) {
                throw new IOException("Error while configuring DaoManager.  The root tag of the DAO configuration XML document must be 'dao-config'.");
            }
            List list = element.getChildren();
            int n = 0;
            while (n < list.size()) {
                Object object;
                Element element2 = (Element)list.get(n);
                if (CONTEXT_ELEMENT.equals(element2.getName())) {
                    object = XmlDaoManagerBuilder.parseContext(element2);
                    arrayList.add((DaoManager)object);
                } else if (PROPERTIES_ELEMENT.equals(element2.getName())) {
                    object = XmlDaoManagerBuilder.getAttributeValue(element2, "resource", true);
                    properties = Resources.getResourceAsProperties((String)object);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new DaoException("Error while configuring DaoManager.  Cause: " + exception.toString(), exception);
        }
        return arrayList.toArray(new DaoManager[arrayList.size()]);
    }

    public static boolean isValidationEnabled() {
        return validationEnabled;
    }

    public static void setValidationEnabled(boolean bl) {
        validationEnabled = bl;
    }

    private static String getAttributeValue(Element element, String string, boolean bl) throws DaoException {
        String string2 = null;
        Attribute attribute = element.getAttribute(string);
        if (attribute != null) {
            string2 = attribute.getValue();
        }
        if (properties != null && string2 != null && string2.startsWith("${") && string2.endsWith("}") && string2.length() > 3) {
            String string3 = string2;
            string3 = string3.substring(2);
            String string4 = properties.getProperty(string3 = string3.substring(0, string3.length() - 1));
            string2 = string4 != null ? string4 : System.getProperty(string3, string2);
        }
        if (bl && string2 == null) {
            throw new DaoException("Error while configuring DaoManager.  A '" + element.getName() + "' element requires a '" + string + "' attribute.");
        }
        return string2;
    }

    private static DaoManager parseContext(Element element) throws DaoException {
        DaoManager daoManager = DaoManager.newInstance();
        daoManager.setName(XmlDaoManagerBuilder.getAttributeValue(element, "name", true));
        daoManager.setDefault("true".equals(XmlDaoManagerBuilder.getAttributeValue(element, "default", false)));
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Element element5 = (Element)list.get(n);
            if (TRANS_POOL_ELEMENT.equals(element5.getName())) {
                element2 = element5;
            } else if (DAO_FACTORY_ELEMENT.equals(element5.getName())) {
                element3 = element5;
            } else if (EXTRA_PROPS_ELEMENT.equals(element5.getName())) {
                element4 = element5;
            }
            ++n;
        }
        if (element4 != null) {
            XmlDaoManagerBuilder.parseExtraPropertyElements(daoManager, element4);
        }
        if (element2 != null) {
            XmlDaoManagerBuilder.parseTransactionPool(daoManager, element2);
        }
        if (element3 != null) {
            XmlDaoManagerBuilder.parseDaoFactory(daoManager, element3);
        }
        return daoManager;
    }

    private static DaoTransactionPool parseTransactionPool(DaoManager daoManager, Element element) throws DaoException {
        DaoTransactionPool daoTransactionPool = null;
        String string = XmlDaoManagerBuilder.getAttributeValue(element, "implementation", true);
        try {
            daoTransactionPool = (DaoTransactionPool)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new DaoException("Error while configuring DaoManager.  Cause: " + exception.toString(), exception);
        }
        Properties properties = XmlDaoManagerBuilder.parsePropertyElements(element);
        daoTransactionPool.configure(properties);
        if (daoTransactionPool == null) {
            throw new DaoException("Error while configuring DaoManager.  Some unknown condition caused the DaoTransactionPool to be null after configuration.");
        }
        daoManager.setTransactionPool(daoTransactionPool);
        return daoTransactionPool;
    }

    private static void parseDaoFactory(DaoManager daoManager, Element element) throws DaoException {
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Element element2 = (Element)list.get(n);
            if (DAO_ELEMENT.equals(element2.getName())) {
                String string = XmlDaoManagerBuilder.getAttributeValue(element2, "name", true);
                String string2 = XmlDaoManagerBuilder.getAttributeValue(element2, "implementation", true);
                daoManager.addDaoClass(string, string2);
            }
            ++n;
        }
    }

    private static void parseExtraPropertyElements(DaoManager daoManager, Element element) throws DaoException {
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Element element2 = (Element)list.get(n);
            if (PROPERTY_ELEMENT.equals(element2.getName())) {
                String string = null;
                String string2 = null;
                string = XmlDaoManagerBuilder.getAttributeValue(element2, "name", true);
                string2 = XmlDaoManagerBuilder.getAttributeValue(element2, "value", true);
                daoManager.setExtraProperty(string, string2);
            }
            ++n;
        }
    }

    private static Properties parsePropertyElements(Element element) throws DaoException {
        Properties properties = new Properties();
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Element element2 = (Element)list.get(n);
            if (PROPERTY_ELEMENT.equals(element2.getName())) {
                String string = null;
                String string2 = null;
                string = XmlDaoManagerBuilder.getAttributeValue(element2, "name", true);
                string2 = XmlDaoManagerBuilder.getAttributeValue(element2, "value", true);
                properties.setProperty(string, string2);
            }
            ++n;
        }
        return properties;
    }
}

