/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import com.ibatis.common.util.PaginatedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PaginatedArrayList
implements PaginatedList {
    private static final ArrayList EMPTY_LIST = new ArrayList(0);
    private List list;
    private List page;
    private int pageSize;
    private int index;

    public PaginatedArrayList(int n) {
        this.pageSize = n;
        this.index = 0;
        this.list = new ArrayList();
        this.repaginate();
    }

    public PaginatedArrayList(int n, int n2) {
        this.pageSize = n2;
        this.index = 0;
        this.list = new ArrayList(n);
        this.repaginate();
    }

    public PaginatedArrayList(Collection collection, int n) {
        this.pageSize = n;
        this.index = 0;
        this.list = new ArrayList(collection);
        this.repaginate();
    }

    private void repaginate() {
        if (this.list.isEmpty()) {
            this.page = EMPTY_LIST;
        } else {
            int n = this.index * this.pageSize;
            int n2 = n + this.pageSize - 1;
            if (n2 >= this.list.size()) {
                n2 = this.list.size() - 1;
            }
            if (n >= this.list.size()) {
                this.index = 0;
                this.repaginate();
            } else if (n < 0) {
                this.index = this.list.size() / this.pageSize;
                if (this.list.size() % this.pageSize == 0) {
                    --this.index;
                }
                this.repaginate();
            } else {
                this.page = this.list.subList(n, n2 + 1);
            }
        }
    }

    public int size() {
        return this.page.size();
    }

    public boolean isEmpty() {
        return this.page.isEmpty();
    }

    public boolean contains(Object object) {
        return this.page.contains(object);
    }

    public Iterator iterator() {
        return this.page.iterator();
    }

    public Object[] toArray() {
        return this.page.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.page.toArray(objectArray);
    }

    public boolean containsAll(Collection collection) {
        return this.page.containsAll(collection);
    }

    public Object get(int n) {
        return this.page.get(n);
    }

    public int indexOf(Object object) {
        return this.page.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.page.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.page.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.page.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.page.subList(n, n2);
    }

    public boolean add(Object object) {
        boolean bl = this.list.add(object);
        this.repaginate();
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = this.list.remove(object);
        this.repaginate();
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = this.list.addAll(collection);
        this.repaginate();
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = this.list.addAll(n, collection);
        this.repaginate();
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = this.list.removeAll(collection);
        this.repaginate();
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = this.list.retainAll(collection);
        this.repaginate();
        return bl;
    }

    public void clear() {
        this.list.clear();
        this.repaginate();
    }

    public Object set(int n, Object object) {
        Object object2 = this.list.set(n, object);
        this.repaginate();
        return object2;
    }

    public void add(int n, Object object) {
        this.list.add(n, object);
        this.repaginate();
    }

    public Object remove(int n) {
        Object e = this.list.remove(n);
        this.repaginate();
        return e;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isFirstPage() {
        return this.index == 0;
    }

    public boolean isMiddlePage() {
        return !this.isFirstPage() && !this.isLastPage();
    }

    public boolean isLastPage() {
        return this.list.size() - (this.index + 1) * this.pageSize < 1;
    }

    public boolean isNextPageAvailable() {
        return !this.isLastPage();
    }

    public boolean isPreviousPageAvailable() {
        return !this.isFirstPage();
    }

    public void nextPage() {
        ++this.index;
        this.repaginate();
    }

    public void previousPage() {
        --this.index;
        this.repaginate();
    }

    public void gotoPage(int n) {
        this.index = n;
        this.repaginate();
    }

    public int getPageIndex() {
        return this.index;
    }
}

