/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.log;

import com.ibatis.common.log.Log;
import com.ibatis.common.log.LogEntry;
import com.ibatis.common.log.LogLevel;
import com.ibatis.common.log.SystemOutLog;
import com.ibatis.common.resources.Resources;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Logger
implements Log {
    private static final Logger instance;
    private static final List logs;
    private static final List queue;
    private static LogLevel logLevel;
    private Object channel;

    private Logger() {
        this.channel = "DEFAULT_CHANNEL";
    }

    private Logger(Object object) {
        this.channel = object;
    }

    public static Logger getInstance() {
        return instance;
    }

    public static Logger getInstance(Object object) {
        return new Logger(object);
    }

    private static void loadLogConfig() {
        Properties properties = new Properties();
        try {
            properties.load(Resources.getResourceAsStream("properties/Logger.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)((Hashtable)properties).get(string);
            try {
                Logger.addLog((Log)Class.forName(string2).newInstance());
            }
            catch (Exception exception) {
                System.out.println("Error loading Log (" + string + "): " + exception.toString());
            }
        }
    }

    public static void addLog(Log log) {
        List list = logs;
        synchronized (list) {
            logs.add(log);
        }
    }

    public static PrintStream getStdOut() {
        return System.out;
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(LogLevel logLevel) {
        Logger.logLevel = logLevel;
    }

    public void log(LogEntry logEntry) {
        if (logEntry.getLogLevel().getLevel() <= logLevel.getLevel()) {
            List list = queue;
            synchronized (list) {
                queue.add(logEntry);
                queue.notify();
            }
        }
    }

    public void log(LogLevel logLevel, Object object) {
        this.log(new LogEntry(logLevel, this.channel, object));
    }

    public void debug(Object object) {
        this.log(LogLevel.LOG_DEBUG, object);
    }

    public void stdout(Object object) {
        this.log(LogLevel.LOG_STDOUT, object);
    }

    public void info(Object object) {
        this.log(LogLevel.LOG_INFO, object);
    }

    public void warn(Object object) {
        this.log(LogLevel.LOG_WARN, object);
    }

    public void error(Object object) {
        this.log(LogLevel.LOG_ERROR, object);
    }

    public void critical(Object object) {
        this.log(LogLevel.LOG_CRITICAL, object);
    }

    public void flush() {
        List list = queue;
        synchronized (list) {
            Object object;
            while (queue.size() > 0) {
                object = (LogEntry)queue.remove(0);
                List list2 = logs;
                synchronized (list2) {
                    int n = 0;
                    while (n < logs.size()) {
                        ((Log)logs.get(n)).log((LogEntry)object);
                        ++n;
                    }
                }
            }
            object = logs;
            synchronized (object) {
                int n = 0;
                while (n < logs.size()) {
                    Log log = (Log)logs.get(n);
                    log.flush();
                    ++n;
                }
            }
        }
    }

    static {
        logs = new ArrayList();
        queue = new ArrayList();
        instance = new Logger();
        Logger.loadLogConfig();
        if (logs.size() < 1) {
            Logger.addLog(new SystemOutLog());
        }
        Logger.setLogLevel(LogLevel.LOG_DEBUG);
        new ProcessQueueThread().start();
    }

    private static class ProcessQueueThread
    extends Thread {
        public ProcessQueueThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                List list = queue;
                synchronized (list) {
                    while (queue.size() > 0) {
                        LogEntry logEntry = (LogEntry)queue.remove(0);
                        List list2 = logs;
                        synchronized (list2) {
                            int n = 0;
                            while (n < logs.size()) {
                                ((Log)logs.get(n)).log(logEntry);
                                ++n;
                            }
                        }
                    }
                    try {
                        queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

