/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.beans;

import com.ibatis.common.beans.BeansException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.cglib.MetaClass;

public class StaticBeanProbe {
    private static final Object[] noParams = new Object[0];
    private static final Map classMethodCaches = new HashMap();
    private static final Set simpleTypeSet = new HashSet();
    private static boolean useMetaClasses = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean isUseMetaClasses() {
        return useMetaClasses;
    }

    public static void setUseMetaClasses(boolean bl) {
        useMetaClasses = bl;
    }

    public static void setField(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new BeansException("Error setting field.  Cause: " + exception.toString(), exception);
        }
    }

    public static Object getField(Object object, String string) {
        try {
            Field field = object.getClass().getField(string);
            return field.get(object);
        }
        catch (Exception exception) {
            throw new BeansException("Error getting field.  Cause: " + exception.toString(), exception);
        }
    }

    private static ClassMethodCache getCacheForClass(Class clazz) {
        String string = clazz.getName();
        ClassMethodCache classMethodCache = (ClassMethodCache)classMethodCaches.get(string);
        if (classMethodCache == null) {
            classMethodCache = new ClassMethodCache(clazz);
            classMethodCaches.put(string, classMethodCache);
        }
        return classMethodCache;
    }

    public static String[] getReadablePropertyNames(Object object) {
        return StaticBeanProbe.getCacheForClass(object.getClass()).getReadablePropertyNames();
    }

    public static String[] getWriteablePropertyNames(Object object) {
        return StaticBeanProbe.getCacheForClass(object.getClass()).getReadablePropertyNames();
    }

    public static boolean beanEquals(Object object, Object object2) {
        return StaticBeanProbe.beanEquals(object, object2, StaticBeanProbe.getReadablePropertyNames(object), new HashSet());
    }

    public static boolean beanEquals(Object object, Object object2, String[] stringArray) {
        return StaticBeanProbe.beanEquals(object, object2, stringArray, new HashSet());
    }

    private static boolean beanEquals(Object object, Object object2, String[] stringArray, Set set) {
        if (object == object2) {
            return true;
        }
        if (object != null && object.equals(object2)) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            Object object3;
            Object object4 = StaticBeanProbe.getObject(object, stringArray[n]);
            if (object4 == (object3 = StaticBeanProbe.getObject(object2, stringArray[n]))) {
                bl = true;
            } else if (object4 != null && object4.equals(object3)) {
                bl = true;
            } else {
                if (object4 == null && object3 != null) {
                    bl = false;
                    break;
                }
                if (object4 != null && object3 == null) {
                    bl = false;
                    break;
                }
                if (StaticBeanProbe.isSimpleType(object4)) {
                    bl = object4.equals(object3);
                } else {
                    int n2 = System.identityHashCode(object4) + System.identityHashCode(object3);
                    String string = String.valueOf(n2);
                    if (!set.contains(string)) {
                        set.add(string);
                        bl = StaticBeanProbe.beanEquals(object4, object3);
                    }
                }
                if (!bl) break;
            }
            ++n;
        }
        return bl;
    }

    public static int beanHashCode(Object object) {
        return StaticBeanProbe.beanHashCode(object, StaticBeanProbe.getReadablePropertyNames(object), new HashSet());
    }

    public static int beanHashCode(Object object, String[] stringArray) {
        return StaticBeanProbe.beanHashCode(object, stringArray, new HashSet());
    }

    private static int beanHashCode(Object object, String[] stringArray, Set set) {
        int n = object.getClass().getName().hashCode();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object2 = StaticBeanProbe.getObject(object, stringArray[n2]);
            if (object2 != null) {
                if (StaticBeanProbe.isSimpleType(object2)) {
                    n += object2.hashCode();
                } else if (object2 != object && !set.contains(object2)) {
                    set.add(object2);
                    n += StaticBeanProbe.beanHashCode(object2);
                }
                n *= 29;
            }
            ++n2;
        }
        return n;
    }

    private static boolean isSimpleType(Object object) {
        if (simpleTypeSet.contains(object.getClass())) {
            return true;
        }
        if (object instanceof Collection) {
            return true;
        }
        if (object instanceof Map) {
            return true;
        }
        if (object instanceof List) {
            return true;
        }
        if (object instanceof Set) {
            return true;
        }
        return object instanceof Iterator;
    }

    public static Class getPropertyTypeForSetter(Object object, String string) {
        Class clazz = object.getClass();
        if (object instanceof Map) {
            Map map = (Map)object;
            Object v = map.get(string);
            clazz = v == null ? (class$java$lang$Object == null ? (class$java$lang$Object = StaticBeanProbe.class$("java.lang.Object")) : class$java$lang$Object) : v.getClass();
        } else if (string.indexOf(46) > -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                clazz = StaticBeanProbe.getCacheForClass(clazz).getSetterType(string);
            }
        } else {
            clazz = StaticBeanProbe.getCacheForClass(clazz).getSetterType(string);
        }
        return clazz;
    }

    public static Class getPropertyTypeForGetter(Object object, String string) {
        Class clazz = object.getClass();
        if (object instanceof Map) {
            Map map = (Map)object;
            Object v = map.get(string);
            clazz = v == null ? (class$java$lang$Object == null ? (class$java$lang$Object = StaticBeanProbe.class$("java.lang.Object")) : class$java$lang$Object) : v.getClass();
        } else if (string.indexOf(46) > -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                clazz = StaticBeanProbe.getCacheForClass(clazz).getGetterType(string);
            }
        } else {
            clazz = StaticBeanProbe.getCacheForClass(clazz).getGetterType(string);
        }
        return clazz;
    }

    private static Object getArrayProperty(Object object, String string) {
        Object object2 = null;
        try {
            String string2 = string.substring(0, string.indexOf("["));
            int n = Integer.parseInt(string.substring(string.indexOf("[") + 1, string.indexOf("]")));
            object2 = StaticBeanProbe.getProperty(object, string2);
            if (!(object2 instanceof List)) {
                throw new BeansException("The '" + string2 + "' property of the " + object.getClass().getName() + " class is not a List.");
            }
            object2 = ((List)object2).get(n);
        }
        catch (BeansException beansException) {
            throw beansException;
        }
        catch (Exception exception) {
            throw new BeansException("Error getting ordinal value from JavaBean. Cause " + exception, exception);
        }
        return object2;
    }

    private static Object getProperty(Object object, String string) {
        ClassMethodCache classMethodCache = StaticBeanProbe.getCacheForClass(object.getClass());
        try {
            Object object2 = null;
            if (string.indexOf("[") > -1) {
                object2 = StaticBeanProbe.getArrayProperty(object, string);
            } else if (object instanceof Map) {
                object2 = ((Map)object).get(string);
            } else {
                MetaClass metaClass = classMethodCache.getMetaClass(string);
                if (metaClass != null) {
                    Object[] objectArray = metaClass.getPropertyValues(object);
                    object2 = objectArray[0];
                } else {
                    Method method = classMethodCache.getGetter(string);
                    if (method == null) {
                        throw new NoSuchMethodException("No GET method for property " + string + " on instance of " + object.getClass().getName());
                    }
                    object2 = method.invoke(object, noParams);
                }
            }
            return object2;
        }
        catch (BeansException beansException) {
            throw beansException;
        }
        catch (Exception exception) {
            if (object == null) {
                throw new BeansException("Could not get property '" + string + "' from null reference.  Cause: " + exception.toString(), exception);
            }
            throw new BeansException("Could not get property '" + string + "' from " + object.getClass().getName() + ".  Cause: " + exception.toString(), exception);
        }
    }

    private static void setArrayProperty(Object object, String string, Object object2) {
        try {
            String string2 = string.substring(0, string.indexOf("["));
            int n = Integer.parseInt(string.substring(string.indexOf("[") + 1, string.indexOf("]")));
            Object object3 = StaticBeanProbe.getProperty(object, string2);
            if (!(object3 instanceof List)) {
                throw new BeansException("The '" + string2 + "' property of the " + object.getClass().getName() + " class is not a List.");
            }
            ((List)object3).set(n, object2);
        }
        catch (BeansException beansException) {
            throw beansException;
        }
        catch (Exception exception) {
            throw new BeansException("Error getting ordinal value from JavaBean. Cause " + exception, exception);
        }
    }

    private static void setProperty(Object object, String string, Object object2) {
        ClassMethodCache classMethodCache = StaticBeanProbe.getCacheForClass(object.getClass());
        try {
            if (string.indexOf("[") > -1) {
                StaticBeanProbe.setArrayProperty(object, string, object2);
            } else if (object instanceof Map) {
                ((Map)object).put(string, object2);
            } else {
                MetaClass metaClass = classMethodCache.getMetaClass(string);
                if (metaClass != null) {
                    metaClass.setPropertyValues(object, new Object[]{object2});
                } else {
                    Method method = classMethodCache.getSetter(string);
                    if (method == null) {
                        throw new NoSuchMethodException("No SET method for property " + string + " on instance of " + object.getClass().getName());
                    }
                    Object[] objectArray = new Object[]{object2};
                    method.invoke(object, objectArray);
                }
            }
        }
        catch (BeansException beansException) {
            throw beansException;
        }
        catch (Exception exception) {
            if (object == null) {
                throw new BeansException("Could not set property '" + string + "' for null reference.  Cause: " + exception.toString(), exception);
            }
            throw new BeansException("Could not set property '" + string + "' for " + object.getClass().getName() + ".  Cause: " + exception.toString(), exception);
        }
    }

    public static Object getObject(Object object, String string) {
        if (string.indexOf(46) > -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            Object object2 = object;
            while (stringTokenizer.hasMoreTokens()) {
                if ((object2 = StaticBeanProbe.getProperty(object2, stringTokenizer.nextToken())) == null) break;
            }
            return object2;
        }
        return StaticBeanProbe.getProperty(object, string);
    }

    public static void setObject(Object object, String string, Object object2) {
        if (string.indexOf(46) > -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = stringTokenizer.nextToken();
            Object object3 = object;
            while (stringTokenizer.hasMoreTokens()) {
                Class clazz = StaticBeanProbe.getPropertyTypeForSetter(object3, string2);
                Object object4 = object3;
                if ((object3 = StaticBeanProbe.getProperty(object4, string2)) == null) {
                    try {
                        object3 = clazz.newInstance();
                        StaticBeanProbe.setObject(object4, string2, object3);
                    }
                    catch (Exception exception) {
                        throw new BeansException("Cannot set value of property '" + string + "' because '" + string2 + "' is null and cannot be instantiated on instance of " + clazz.getName() + ". Cause:" + exception.toString(), exception);
                    }
                }
                string2 = stringTokenizer.nextToken();
            }
            StaticBeanProbe.setProperty(object3, string2, object2);
        } else {
            StaticBeanProbe.setProperty(object, string, object2);
        }
    }

    public static String getString(Object object, String string) {
        return (String)StaticBeanProbe.getObject(object, string);
    }

    public static void setString(Object object, String string, String string2) {
        StaticBeanProbe.setObject(object, string, string2);
    }

    public static int getInteger(Object object, String string) {
        return (Integer)StaticBeanProbe.getObject(object, string);
    }

    public static void setInteger(Object object, String string, int n) {
        StaticBeanProbe.setObject(object, string, new Integer(n));
    }

    public static long getLong(Object object, String string) {
        return (Long)StaticBeanProbe.getObject(object, string);
    }

    public static void setLong(Object object, String string, long l) {
        StaticBeanProbe.setObject(object, string, new Long(l));
    }

    public static short getShort(Object object, String string) {
        return (Short)StaticBeanProbe.getObject(object, string);
    }

    public static void setShort(Object object, String string, short s) {
        StaticBeanProbe.setObject(object, string, new Short(s));
    }

    public static byte getByte(Object object, String string) {
        return (Byte)StaticBeanProbe.getObject(object, string);
    }

    public static void setByte(Object object, String string, byte by) {
        StaticBeanProbe.setObject(object, string, new Byte(by));
    }

    public char getCharacter(Object object, String string) {
        return ((Character)StaticBeanProbe.getObject(object, string)).charValue();
    }

    public static void setCharacter(Object object, String string, char c) {
        StaticBeanProbe.setObject(object, string, new Character(c));
    }

    public static double getDouble(Object object, String string) {
        return (Double)StaticBeanProbe.getObject(object, string);
    }

    public static void setDouble(Object object, String string, double d) {
        StaticBeanProbe.setObject(object, string, new Double(d));
    }

    public static float getFloat(Object object, String string) {
        return ((Float)StaticBeanProbe.getObject(object, string)).floatValue();
    }

    public static void setFloat(Object object, String string, float f) {
        StaticBeanProbe.setObject(object, string, new Float(f));
    }

    public static boolean getBoolean(Object object, String string) {
        return (Boolean)StaticBeanProbe.getObject(object, string);
    }

    public static void setBoolean(Object object, String string, boolean bl) {
        StaticBeanProbe.setObject(object, string, new Boolean(bl));
    }

    public static Date getDate(Object object, String string) {
        return (Date)StaticBeanProbe.getObject(object, string);
    }

    public static void setDate(Object object, String string, Date date) {
        StaticBeanProbe.setObject(object, string, date);
    }

    public static boolean hasWritableProperty(Object object, String string) {
        if (object instanceof Map) {
            return ((Map)object).containsKey(string);
        }
        return StaticBeanProbe.getCacheForClass(object.getClass()).hasWritableProperty(string);
    }

    public static boolean hasReadableProperty(Object object, String string) {
        if (object instanceof Map) {
            return ((Map)object).containsKey(string);
        }
        return StaticBeanProbe.getCacheForClass(object.getClass()).hasReadableProperty(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        simpleTypeSet.add(class$java$lang$String == null ? (class$java$lang$String = StaticBeanProbe.class$("java.lang.String")) : class$java$lang$String);
        simpleTypeSet.add(class$java$lang$Byte == null ? (class$java$lang$Byte = StaticBeanProbe.class$("java.lang.Byte")) : class$java$lang$Byte);
        simpleTypeSet.add(class$java$lang$Short == null ? (class$java$lang$Short = StaticBeanProbe.class$("java.lang.Short")) : class$java$lang$Short);
        simpleTypeSet.add(class$java$lang$Character == null ? (class$java$lang$Character = StaticBeanProbe.class$("java.lang.Character")) : class$java$lang$Character);
        simpleTypeSet.add(class$java$lang$Integer == null ? (class$java$lang$Integer = StaticBeanProbe.class$("java.lang.Integer")) : class$java$lang$Integer);
        simpleTypeSet.add(class$java$lang$Long == null ? (class$java$lang$Long = StaticBeanProbe.class$("java.lang.Long")) : class$java$lang$Long);
        simpleTypeSet.add(class$java$lang$Float == null ? (class$java$lang$Float = StaticBeanProbe.class$("java.lang.Float")) : class$java$lang$Float);
        simpleTypeSet.add(class$java$lang$Double == null ? (class$java$lang$Double = StaticBeanProbe.class$("java.lang.Double")) : class$java$lang$Double);
        simpleTypeSet.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = StaticBeanProbe.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        simpleTypeSet.add(class$java$util$Date == null ? (class$java$util$Date = StaticBeanProbe.class$("java.util.Date")) : class$java$util$Date);
        simpleTypeSet.add(class$java$lang$Class == null ? (class$java$lang$Class = StaticBeanProbe.class$("java.lang.Class")) : class$java$lang$Class);
        simpleTypeSet.add(class$java$math$BigInteger == null ? (class$java$math$BigInteger = StaticBeanProbe.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        simpleTypeSet.add(class$java$util$Collection == null ? (class$java$util$Collection = StaticBeanProbe.class$("java.util.Collection")) : class$java$util$Collection);
        simpleTypeSet.add(class$java$util$HashMap == null ? (class$java$util$HashMap = StaticBeanProbe.class$("java.util.HashMap")) : class$java$util$HashMap);
        simpleTypeSet.add(class$java$util$TreeMap == null ? (class$java$util$TreeMap = StaticBeanProbe.class$("java.util.TreeMap")) : class$java$util$TreeMap);
        simpleTypeSet.add(class$java$util$ArrayList == null ? (class$java$util$ArrayList = StaticBeanProbe.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        simpleTypeSet.add(class$java$util$LinkedList == null ? (class$java$util$LinkedList = StaticBeanProbe.class$("java.util.LinkedList")) : class$java$util$LinkedList);
        simpleTypeSet.add(class$java$util$HashSet == null ? (class$java$util$HashSet = StaticBeanProbe.class$("java.util.HashSet")) : class$java$util$HashSet);
        simpleTypeSet.add(class$java$util$TreeSet == null ? (class$java$util$TreeSet = StaticBeanProbe.class$("java.util.TreeSet")) : class$java$util$TreeSet);
        simpleTypeSet.add(class$java$util$Vector == null ? (class$java$util$Vector = StaticBeanProbe.class$("java.util.Vector")) : class$java$util$Vector);
        simpleTypeSet.add(class$java$util$Hashtable == null ? (class$java$util$Hashtable = StaticBeanProbe.class$("java.util.Hashtable")) : class$java$util$Hashtable);
        simpleTypeSet.add(class$java$util$Enumeration == null ? (class$java$util$Enumeration = StaticBeanProbe.class$("java.util.Enumeration")) : class$java$util$Enumeration);
    }

    private static class ClassMethodCache {
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        private String className;
        private String[] readablePropertyNames = EMPTY_STRING_ARRAY;
        private String[] writeablePropertyNames = EMPTY_STRING_ARRAY;
        private HashMap setMethods = new HashMap();
        private HashMap getMethods = new HashMap();
        private HashMap setTypes = new HashMap();
        private HashMap getTypes = new HashMap();
        private HashMap metaClassMap = new HashMap();

        public ClassMethodCache(Class clazz) {
            this.className = clazz.getName();
            this.addMethods(clazz);
            Class clazz2 = clazz.getSuperclass();
            while (clazz2 != null) {
                this.addMethods(clazz2);
                clazz2 = clazz2.getSuperclass();
            }
            this.readablePropertyNames = this.getMethods.keySet().toArray(new String[this.getMethods.keySet().size()]);
            this.writeablePropertyNames = this.setMethods.keySet().toArray(new String[this.setMethods.keySet().size()]);
            this.initializeMetaClasses(clazz);
        }

        private void addMethods(Class clazz) {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                String string = methodArray[n].getName();
                if (string.indexOf("set") == 0 && string.length() > 3) {
                    if (methodArray[n].getParameterTypes().length == 1) {
                        string = string.substring(3, 4).toLowerCase() + string.substring(4);
                        this.setMethods.put(string, methodArray[n]);
                        this.setTypes.put(string, methodArray[n].getParameterTypes()[0]);
                    }
                } else if (string.indexOf("get") == 0 && string.length() > 3) {
                    if (methodArray[n].getParameterTypes().length == 0) {
                        string = string.substring(3, 4).toLowerCase() + string.substring(4);
                        this.getMethods.put(string, methodArray[n]);
                        this.getTypes.put(string, methodArray[n].getReturnType());
                    }
                } else if (string.indexOf("is") == 0 && string.length() > 2 && methodArray[n].getParameterTypes().length == 0) {
                    string = string.substring(2, 3).toLowerCase() + string.substring(3);
                    this.getMethods.put(string, methodArray[n]);
                    this.getTypes.put(string, methodArray[n].getReturnType());
                }
                string = null;
                ++n;
            }
        }

        private void initializeMetaClasses(Class clazz) {
            if (useMetaClasses) {
                String[] stringArray = this.getReadablePropertyNames();
                int n = 0;
                while (n < stringArray.length) {
                    if (this.hasWritableProperty(stringArray[n])) {
                        try {
                            MetaClass metaClass = MetaClass.getInstance((ClassLoader)clazz.getClassLoader(), (Class)clazz, (String[])new String[]{this.getGetter(stringArray[n]).getName()}, (String[])new String[]{this.getSetter(stringArray[n]).getName()}, (Class[])new Class[]{this.getGetterType(stringArray[n])});
                            this.metaClassMap.put(stringArray[n], metaClass);
                        }
                        catch (Throwable throwable) {
                            throw new BeansException("Error creating MetaClass for " + clazz + ".  Cause: " + throwable.toString(), throwable);
                        }
                    }
                    ++n;
                }
            }
        }

        public String getClassName() {
            return this.className;
        }

        public MetaClass getMetaClass(String string) {
            return (MetaClass)this.metaClassMap.get(string);
        }

        public Method getSetter(String string) {
            Method method = (Method)this.setMethods.get(string);
            if (method == null) {
                throw new BeansException("There is no WRITEABLE property named '" + string + "' in class '" + this.className + "'");
            }
            return method;
        }

        public Method getGetter(String string) {
            Method method = (Method)this.getMethods.get(string);
            if (method == null) {
                throw new BeansException("There is no READABLE property named '" + string + "' in class '" + this.className + "'");
            }
            return method;
        }

        public Class getSetterType(String string) {
            Class clazz = (Class)this.setTypes.get(string);
            if (clazz == null) {
                throw new BeansException("There is no WRITEABLE property named '" + string + "' in class '" + this.className + "'");
            }
            return clazz;
        }

        public Class getGetterType(String string) {
            Class clazz = (Class)this.getTypes.get(string);
            if (clazz == null) {
                throw new BeansException("There is no READABLE property named '" + string + "' in class '" + this.className + "'");
            }
            return clazz;
        }

        public String[] getReadablePropertyNames() {
            return this.readablePropertyNames;
        }

        public String[] getWriteablePropertyNames() {
            return this.writeablePropertyNames;
        }

        public boolean hasWritableProperty(String string) {
            return this.setMethods.keySet().contains(string);
        }

        public boolean hasReadableProperty(String string) {
            return this.getMethods.keySet().contains(string);
        }
    }
}

