/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.ConstructorProxy;
import net.sf.cglib.KeyFactory;
import net.sf.cglib.MethodProxy;

public abstract class MetaClass {
    private static final Map cache = new Hashtable();
    private static final MetaClassKey keyFactory = (MetaClassKey)((Object)KeyFactory.create(class$net$sf$cglib$MetaClass$MetaClassKey == null ? (class$net$sf$cglib$MetaClass$MetaClassKey = MetaClass.class$("net.sf.cglib.MetaClass$MetaClassKey")) : class$net$sf$cglib$MetaClass$MetaClassKey, null));
    private static final MemberKey memberKeyFactory = (MemberKey)((Object)KeyFactory.create(class$net$sf$cglib$MetaClass$MemberKey == null ? (class$net$sf$cglib$MetaClass$MemberKey = MetaClass.class$("net.sf.cglib.MetaClass$MemberKey")) : class$net$sf$cglib$MetaClass$MemberKey, null));
    private static int index = 0;
    private static final ClassLoader defaultLoader = (class$net$sf$cglib$MetaClass == null ? (class$net$sf$cglib$MetaClass = MetaClass.class$("net.sf.cglib.MetaClass")) : class$net$sf$cglib$MetaClass).getClassLoader();
    protected Class target;
    protected String[] getters;
    protected String[] setters;
    protected Class[] types;
    protected Map memebers = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$net$sf$cglib$MetaClass$MetaClassKey;
    static /* synthetic */ Class class$net$sf$cglib$MetaClass$MemberKey;
    static /* synthetic */ Class class$net$sf$cglib$MetaClass;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Class;

    protected MetaClass(Class target, String[] getters, String[] setters, Class[] types) {
        this.target = target;
        this.getters = new String[getters.length];
        System.arraycopy(getters, 0, this.getters, 0, getters.length);
        this.setters = new String[setters.length];
        System.arraycopy(setters, 0, this.setters, 0, setters.length);
        this.types = new Class[types.length];
        System.arraycopy(types, 0, this.types, 0, types.length);
        this.addMembers();
    }

    public Class[] getPropertyTypes() {
        return (Class[])this.types.clone();
    }

    private void addMembers() {
        Method[] methods = this.target.getMethods();
        int i = 0;
        while (i < methods.length) {
            Object key = memberKeyFactory.newInstance(this.target, methods[i].getName(), methods[i].getParameterTypes());
            this.memebers.put(key, MethodProxy.create(methods[i], methods[i]));
            ++i;
        }
        Constructor<?>[] constructors = this.target.getConstructors();
        int i2 = 0;
        while (i2 < constructors.length) {
            Object key = memberKeyFactory.newInstance(this.target, "<init>", constructors[i2].getParameterTypes());
            this.memebers.put(key, ConstructorProxy.create(constructors[i2]));
            ++i2;
        }
    }

    public MethodProxy getMethod(String name, Class[] types) {
        Object key = memberKeyFactory.newInstance(this.target, name, types);
        return (MethodProxy)this.memebers.get(key);
    }

    public ConstructorProxy getConstructor(Class[] types) {
        Object key = memberKeyFactory.newInstance(this.target, "<init>", types);
        return (ConstructorProxy)this.memebers.get(key);
    }

    public String[] getGetters() {
        return (String[])this.getters.clone();
    }

    public String[] getSetters() {
        return (String[])this.setters.clone();
    }

    private static Method findDeclaredMethod(Class clazz, String name, Class[] types) throws NoSuchMethodException {
        Class cl = clazz;
        while (cl != null) {
            try {
                return cl.getDeclaredMethod(name, types);
            }
            catch (NoSuchMethodException nsme) {
                cl = cl.getSuperclass();
            }
        }
        throw new NoSuchMethodException(name);
    }

    private static void validate(Class target, String[] getters, String[] setters, Class[] types, Method[] getters_out, Method[] setters_out) {
        int length = types.length;
        if (setters.length != length || length != getters.length) {
            throw new IllegalArgumentException("accessor array length must be equal type array length");
        }
        String last = null;
        try {
            int i = 0;
            while (i < types.length) {
                Method method;
                if (getters[i] != null) {
                    last = getters[i];
                    method = MetaClass.findDeclaredMethod(target, last, new Class[0]);
                    int mod = method.getModifiers();
                    if (method.getReturnType() != types[i] || Modifier.isPrivate(mod)) {
                        throw new IllegalArgumentException(last);
                    }
                    getters_out[i] = method;
                }
                if (setters[i] != null) {
                    last = setters[i];
                    method = MetaClass.findDeclaredMethod(target, last, new Class[]{types[i]});
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new IllegalArgumentException(last);
                    }
                    setters_out[i] = method;
                }
                ++i;
            }
        }
        catch (NoSuchMethodException nesme) {
            throw new IllegalArgumentException(last);
        }
    }

    public static MetaClass getInstance(ClassLoader loader, Class target, String[] getters, String[] setters, Class[] types) throws Throwable {
        MetaClass result;
        if (loader == null) {
            loader = defaultLoader;
        }
        Object key = keyFactory.newInstance(target, getters, setters, types);
        Map map = cache;
        synchronized (map) {
            result = (MetaClass)cache.get(key);
            if (result != null) {
                MetaClass metaClass = result;
                return metaClass;
            }
            Method[] g = new Method[types.length];
            Method[] s = new Method[types.length];
            String name = target.getName() + "MetaClass" + index++;
            MetaClass.validate(target, getters, setters, types, g, s);
            MetaClassGenerator generator = new MetaClassGenerator(name, loader, target, g, s);
            Class clazz = generator.define();
            result = (MetaClass)clazz.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = MetaClass.class$("java.lang.Class")) : class$java$lang$Class, array$Ljava$lang$String == null ? (array$Ljava$lang$String = MetaClass.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = MetaClass.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = MetaClass.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class).newInstance(target, getters, setters, types);
            cache.put(key, result);
        }
        return result;
    }

    public abstract Object newInstance();

    public abstract Object[] getPropertyValues(Object var1);

    public abstract void setPropertyValues(Object var1, Object[] var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MetaClassGenerator
    extends CodeGenerator {
        private Class target;
        private Method[] getters;
        private Method[] setters;
        static /* synthetic */ Class class$net$sf$cglib$MetaClass;
        static /* synthetic */ Class class$java$lang$Class;
        static /* synthetic */ Class array$Ljava$lang$String;
        static /* synthetic */ Class array$Ljava$lang$Class;
        static /* synthetic */ Class class$java$lang$Object;
        static /* synthetic */ Class array$Ljava$lang$Object;

        protected MetaClassGenerator(String className, ClassLoader loader, Class target, Method[] getters, Method[] setters) {
            super(className, class$net$sf$cglib$MetaClass == null ? (class$net$sf$cglib$MetaClass = MetaClassGenerator.class$("net.sf.cglib.MetaClass")) : class$net$sf$cglib$MetaClass, loader);
            this.target = target;
            this.getters = getters;
            this.setters = setters;
        }

        public void generate() throws NoSuchMethodException {
            Constructor constructor = (class$net$sf$cglib$MetaClass == null ? (class$net$sf$cglib$MetaClass = MetaClassGenerator.class$("net.sf.cglib.MetaClass")) : class$net$sf$cglib$MetaClass).getDeclaredConstructor(class$java$lang$Class == null ? (class$java$lang$Class = MetaClassGenerator.class$("java.lang.Class")) : class$java$lang$Class, array$Ljava$lang$String == null ? (array$Ljava$lang$String = MetaClassGenerator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = MetaClassGenerator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = MetaClassGenerator.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class);
            this.begin_constructor(constructor);
            this.load_this();
            this.load_args();
            this.super_invoke(constructor);
            this.return_value();
            this.end_method();
            Method newInstance = (class$net$sf$cglib$MetaClass == null ? (class$net$sf$cglib$MetaClass = MetaClassGenerator.class$("net.sf.cglib.MetaClass")) : class$net$sf$cglib$MetaClass).getMethod("newInstance", new Class[0]);
            this.begin_method(newInstance);
            this.new_instance(this.target);
            this.dup();
            this.invoke_constructor(this.target);
            this.return_value();
            this.end_method();
            Method getPropertyValues = (class$net$sf$cglib$MetaClass == null ? (class$net$sf$cglib$MetaClass = MetaClassGenerator.class$("net.sf.cglib.MetaClass")) : class$net$sf$cglib$MetaClass).getMethod("getPropertyValues", class$java$lang$Object == null ? (class$java$lang$Object = MetaClassGenerator.class$("java.lang.Object")) : class$java$lang$Object);
            this.begin_method(getPropertyValues);
            Object bean = this.make_local();
            this.load_arg(0);
            this.checkcast(this.target);
            this.store_local(bean);
            this.push(this.getters.length);
            this.newarray();
            int i = 0;
            while (i < this.getters.length) {
                if (this.getters[i] != null) {
                    this.dup();
                    this.push(i);
                    this.load_local(bean);
                    this.invoke(this.getters[i]);
                    this.box(this.getters[i].getReturnType());
                    this.aastore();
                }
                ++i;
            }
            this.return_value();
            this.end_method();
            Method setPropertyValues = (class$net$sf$cglib$MetaClass == null ? (class$net$sf$cglib$MetaClass = MetaClassGenerator.class$("net.sf.cglib.MetaClass")) : class$net$sf$cglib$MetaClass).getMethod("setPropertyValues", class$java$lang$Object == null ? (class$java$lang$Object = MetaClassGenerator.class$("java.lang.Object")) : class$java$lang$Object, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = MetaClassGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            this.begin_method(setPropertyValues);
            this.load_arg(0);
            this.checkcast(this.target);
            this.load_arg(1);
            int i2 = 0;
            while (i2 < this.setters.length) {
                if (this.setters[i2] != null) {
                    this.dup2();
                    this.aaload(i2);
                    this.unbox(this.setters[i2].getParameterTypes()[0]);
                    this.invoke(this.setters[i2]);
                }
                ++i2;
            }
            this.return_value();
            this.end_method();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static interface MemberKey {
        public Object newInstance(Class var1, String var2, Class[] var3);
    }

    static interface MetaClassKey {
        public Object newInstance(Class var1, String[] var2, String[] var3, Class[] var4);
    }
}

