/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.CodeGeneratorBackend;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.Type;

class BCELBackend
extends CodeGeneratorBackend
implements Constants {
    private final ClassGen cg;
    private final InstructionList il = new InstructionList();
    private final ConstantPoolGen cp;
    private MethodGen mg;
    private Map branches = new HashMap();
    private Map labels = new HashMap();

    public BCELBackend(String className, Class superclass) {
        super(className, superclass);
        this.cg = new ClassGen(className, superclass.getName(), "<generated>", 1, null);
        this.cp = this.cg.getConstantPool();
    }

    public void setInterface(boolean flag) {
        if (flag) {
            this.cg.setAccessFlags(this.cg.getAccessFlags() | 0x200);
        } else {
            this.cg.setAccessFlags(this.cg.getAccessFlags() & 0xFFFFFDFF);
        }
    }

    public byte[] getBytes() {
        return this.cg.getJavaClass().getBytes();
    }

    public void ifeq(Object label) {
        this.append((BranchInstruction)new IFEQ(null), label);
    }

    public void ifne(Object label) {
        this.append((BranchInstruction)new IFNE(null), label);
    }

    public void iflt(Object label) {
        this.append((BranchInstruction)new IFLT(null), label);
    }

    public void ifge(Object label) {
        this.append((BranchInstruction)new IFGE(null), label);
    }

    public void ifgt(Object label) {
        this.append((BranchInstruction)new IFGT(null), label);
    }

    public void ifle(Object label) {
        this.append((BranchInstruction)new IFLE(null), label);
    }

    public void goTo(Object label) {
        this.append((BranchInstruction)new GOTO(null), label);
    }

    public void ifnull(Object label) {
        this.append((BranchInstruction)new IFNULL(null), label);
    }

    public void ifnonnull(Object label) {
        this.append((BranchInstruction)new IFNONNULL(null), label);
    }

    public void if_icmplt(Object label) {
        this.append((BranchInstruction)new IF_ICMPLT(null), label);
    }

    public void if_icmpne(Object label) {
        this.append((BranchInstruction)new IF_ICMPNE(null), label);
    }

    public void if_icmpeq(Object label) {
        this.append((BranchInstruction)new IF_ICMPEQ(null), label);
    }

    public void nop(Object label) {
        this.append(label, (Instruction)new NOP());
    }

    public void imul() {
        this.append((Instruction)new IMUL());
    }

    public void iadd() {
        this.append((Instruction)new IADD());
    }

    public void lushr() {
        this.append((Instruction)new LUSHR());
    }

    public void lxor() {
        this.append((Instruction)new LXOR());
    }

    public void ixor() {
        this.append((Instruction)new IXOR());
    }

    public void l2i() {
        this.append((Instruction)new L2I());
    }

    public void dcmpg() {
        this.append((Instruction)new DCMPG());
    }

    public void fcmpg() {
        this.append((Instruction)new FCMPG());
    }

    public void lcmp() {
        this.append((Instruction)new LCMP());
    }

    public void aconst_null() {
        this.append((Instruction)new ACONST_NULL());
    }

    public void arraylength() {
        this.append((Instruction)new ARRAYLENGTH());
    }

    public void newarray(Class clazz) {
        this.append((Instruction)new NEWARRAY((BasicType)this.getType(clazz)));
    }

    public void anewarray(Class clazz) {
        this.append((Instruction)new ANEWARRAY(this.cp.addClass(clazz.getName())));
    }

    public void new_instance(String className) {
        this.append((Instruction)new NEW(this.cp.addClass(className)));
    }

    public void checkcast(String className) {
        this.append((Instruction)new CHECKCAST(this.cp.addClass(className)));
    }

    public void instance_of(String className) {
        this.append((Instruction)new INSTANCEOF(this.cp.addClass(className)));
    }

    public void aaload() {
        this.append((Instruction)new AALOAD());
    }

    public void aastore() {
        this.append((Instruction)new AASTORE());
    }

    public void athrow() {
        this.append((Instruction)new ATHROW());
    }

    public void pop() {
        this.append((Instruction)new POP());
    }

    public void pop2() {
        this.append((Instruction)new POP2());
    }

    public void dup() {
        this.append((Instruction)new DUP());
    }

    public void dup2() {
        this.append((Instruction)new DUP2());
    }

    public void dup_x1() {
        this.append((Instruction)new DUP_X1());
    }

    public void dup_x2() {
        this.append((Instruction)new DUP_X2());
    }

    public void swap() {
        this.append((Instruction)new SWAP());
    }

    public void invoke_interface(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.append((Instruction)new INVOKEINTERFACE(this.cp.addInterfaceMethodref(className, methodName, this.getSignature(returnType, parameterTypes)), 1 + CodeGenerator.getStackSize(parameterTypes)));
    }

    public void invoke_virtual(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.append((Instruction)new INVOKEVIRTUAL(this.cp.addMethodref(className, methodName, this.getSignature(returnType, parameterTypes))));
    }

    public void invoke_static(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.append((Instruction)new INVOKESTATIC(this.cp.addMethodref(className, methodName, this.getSignature(returnType, parameterTypes))));
    }

    public void invoke_special(String className, String methodName, Class returnType, Class[] parameterTypes) {
        this.append((Instruction)new INVOKESPECIAL(this.cp.addMethodref(className, methodName, this.getSignature(returnType, parameterTypes))));
    }

    private String getSignature(Class returnType, Class[] parameterTypes) {
        return Type.getMethodSignature((Type)this.getType(returnType), (Type[])this.getTypes(parameterTypes));
    }

    private String getSignature(Class type) {
        return this.getType(type).getSignature();
    }

    public void declare_field(int modifiers, Class typeClass, String fieldName) {
        Type type = this.getType(typeClass);
        FieldGen fg = new FieldGen(BCELBackend.convertModifiers(modifiers), type, fieldName, this.cp);
        this.cg.addField(fg.getField());
        this.cp.addFieldref(this.className, fieldName, this.getSignature(typeClass));
    }

    public void getfield(String className, String fieldName, Class type) {
        this.append((Instruction)new GETFIELD(this.cp.addFieldref(className, fieldName, this.getSignature(type))));
    }

    public void putfield(String className, String fieldName, Class type) {
        this.append((Instruction)new PUTFIELD(this.cp.addFieldref(className, fieldName, this.getSignature(type))));
    }

    public void getstatic(String className, String fieldName, Class type) {
        this.append((Instruction)new GETSTATIC(this.cp.addFieldref(className, fieldName, this.getSignature(type))));
    }

    public void putstatic(String className, String fieldName, Class type) {
        this.append((Instruction)new PUTSTATIC(this.cp.addFieldref(className, fieldName, this.getSignature(type))));
    }

    public void begin_static() {
        this.mg = new MethodGen(8, (Type)Type.VOID, new Type[0], null, "<clinit>", this.className, this.il, this.cp);
    }

    public void declare_interface(Class iface) {
        this.cg.addInterface(iface.getName());
    }

    public void begin_method(int modifiers, Class returnType, String methodName, Class[] parameterTypes, Class[] exceptionTypes) {
        this.mg = new MethodGen(BCELBackend.convertModifiers(modifiers), this.getType(returnType), this.getTypes(parameterTypes), null, methodName, this.className, this.il, this.cp);
        if (exceptionTypes != null) {
            int i = 0;
            while (i < exceptionTypes.length) {
                this.mg.addException(exceptionTypes[i].getName());
                ++i;
            }
        }
    }

    public Object start_range() {
        return this.il.append((Instruction)new NOP());
    }

    public Object end_range() {
        return this.il.getEnd().getPrev();
    }

    public void handle_exception(Object start, Object end, Class exceptionType) {
        this.mg.addExceptionHandler((InstructionHandle)start, (InstructionHandle)end, this.il.append((Instruction)new NOP()), (ObjectType)this.getType(exceptionType));
    }

    public void begin_constructor(Class[] parameterTypes) {
        this.mg = new MethodGen(1, (Type)Type.VOID, this.getTypes(parameterTypes), null, "<init>", this.className, this.il, this.cp);
    }

    public void end_method() {
        this.setTargets();
        if (this.debug) {
            System.out.println(this.mg.getMethod());
            System.out.println(this.mg.getMethod().getCode());
        }
        this.mg.removeNOPs();
        this.mg.stripAttributes(true);
        this.mg.setMaxLocals();
        this.mg.setMaxStack();
        this.cg.addMethod(this.mg.getMethod());
        this.il.dispose();
    }

    public Object make_label() {
        return new Object();
    }

    public void ldc(String value) {
        this.append((Instruction)new LDC(this.cp.addString(value)));
    }

    public void ldc(double value) {
        this.append((Instruction)new LDC(this.cp.addDouble(value)));
    }

    public void ldc(long value) {
        this.append((Instruction)new LDC(this.cp.addLong(value)));
    }

    public void ldc(int value) {
        this.append((Instruction)new LDC(this.cp.addInteger(value)));
    }

    public void ldc(float value) {
        this.append((Instruction)new LDC(this.cp.addFloat(value)));
    }

    public void laload() {
        this.append((Instruction)new LALOAD());
    }

    public void daload() {
        this.append((Instruction)new DALOAD());
    }

    public void faload() {
        this.append((Instruction)new FALOAD());
    }

    public void saload() {
        this.append((Instruction)new SALOAD());
    }

    public void caload() {
        this.append((Instruction)new CALOAD());
    }

    public void iaload() {
        this.append((Instruction)new IALOAD());
    }

    public void baload() {
        this.append((Instruction)new BALOAD());
    }

    public void lastore() {
        this.append((Instruction)new LASTORE());
    }

    public void dastore() {
        this.append((Instruction)new DASTORE());
    }

    public void fastore() {
        this.append((Instruction)new FASTORE());
    }

    public void sastore() {
        this.append((Instruction)new SASTORE());
    }

    public void castore() {
        this.append((Instruction)new CASTORE());
    }

    public void iastore() {
        this.append((Instruction)new IASTORE());
    }

    public void bastore() {
        this.append((Instruction)new BASTORE());
    }

    public void iconst(int value) {
        this.append((Instruction)new ICONST(value));
    }

    public void bipush(byte value) {
        this.append((Instruction)new BIPUSH(value));
    }

    public void sipush(short value) {
        this.append((Instruction)new SIPUSH(value));
    }

    public void lconst(long value) {
        this.append((Instruction)new LCONST(value));
    }

    public void fconst(float value) {
        this.append((Instruction)new FCONST(value));
    }

    public void dconst(double value) {
        this.append((Instruction)new DCONST(value));
    }

    public void lload(int index) {
        this.append((Instruction)new LLOAD(index));
    }

    public void dload(int index) {
        this.append((Instruction)new DLOAD(index));
    }

    public void fload(int index) {
        this.append((Instruction)new FLOAD(index));
    }

    public void iload(int index) {
        this.append((Instruction)new ILOAD(index));
    }

    public void aload(int index) {
        this.append((Instruction)new ALOAD(index));
    }

    public void lstore(int index) {
        this.append((Instruction)new LSTORE(index));
    }

    public void dstore(int index) {
        this.append((Instruction)new DSTORE(index));
    }

    public void fstore(int index) {
        this.append((Instruction)new FSTORE(index));
    }

    public void istore(int index) {
        this.append((Instruction)new ISTORE(index));
    }

    public void astore(int index) {
        this.append((Instruction)new ASTORE(index));
    }

    public void returnVoid() {
        this.append((Instruction)new RETURN());
    }

    public void lreturn() {
        this.append((Instruction)new LRETURN());
    }

    public void dreturn() {
        this.append((Instruction)new DRETURN());
    }

    public void freturn() {
        this.append((Instruction)new FRETURN());
    }

    public void ireturn() {
        this.append((Instruction)new IRETURN());
    }

    public void areturn() {
        this.append((Instruction)new ARETURN());
    }

    public void iinc(int index, int amount) {
        this.append((Instruction)new IINC(index, amount));
    }

    private void append(Instruction intruction) {
        this.il.append(intruction);
    }

    private void append(Object label, Instruction instruction) {
        if (label != null) {
            if (null != this.labels.put(label, this.il.append(instruction))) {
                throw new IllegalStateException("duplicated label " + label);
            }
        } else {
            this.il.append(instruction);
        }
    }

    private void append(BranchInstruction instruction, Object label) {
        LinkedList<BranchInstruction> list = (LinkedList<BranchInstruction>)this.branches.get(label);
        if (list == null) {
            list = new LinkedList<BranchInstruction>();
            this.branches.put(label, list);
        }
        list.add(instruction);
        this.il.append(instruction);
    }

    private Type[] getTypes(Class[] classes) {
        Type[] types = new Type[classes.length];
        int i = 0;
        while (i < types.length) {
            types[i] = this.getType(classes[i]);
            ++i;
        }
        return types;
    }

    private static int convertModifiers(int modifiers) {
        int result = 0;
        if (Modifier.isAbstract(modifiers)) {
            result |= 0x400;
        }
        if (Modifier.isFinal(modifiers)) {
            result |= 0x10;
        }
        if (Modifier.isInterface(modifiers)) {
            result |= 0x200;
        }
        if (Modifier.isNative(modifiers)) {
            result |= 0x100;
        }
        if (Modifier.isPrivate(modifiers)) {
            result |= 2;
        }
        if (Modifier.isProtected(modifiers)) {
            result |= 4;
        }
        if (Modifier.isPublic(modifiers)) {
            result |= 1;
        }
        if (Modifier.isStatic(modifiers)) {
            result |= 8;
        }
        if (Modifier.isStrict(modifiers)) {
            result |= 0x800;
        }
        if (Modifier.isSynchronized(modifiers)) {
            result |= 0x20;
        }
        if (Modifier.isTransient(modifiers)) {
            result |= 0x80;
        }
        if (Modifier.isVolatile(modifiers)) {
            result |= 0x40;
        }
        return result;
    }

    private void setTargets() {
        if (this.labels.size() > 0 && this.branches.size() > 0) {
            Iterator labelIterator = this.labels.entrySet().iterator();
            while (labelIterator.hasNext()) {
                Map.Entry label = labelIterator.next();
                List branchInstructions = (List)this.branches.get(label.getKey());
                if (branchInstructions == null) continue;
                Iterator instructions = branchInstructions.iterator();
                while (instructions.hasNext()) {
                    BranchInstruction instruction = (BranchInstruction)instructions.next();
                    instruction.setTarget((InstructionHandle)label.getValue());
                }
            }
        }
        this.labels.clear();
        this.branches.clear();
    }

    private Type getType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (clazz.isArray()) {
            return Type.getType((String)clazz.getName());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return Type.INT;
            }
            if (clazz == Void.TYPE) {
                return Type.VOID;
            }
            if (clazz == Double.TYPE) {
                return Type.DOUBLE;
            }
            if (clazz == Float.TYPE) {
                return Type.FLOAT;
            }
            if (clazz == Boolean.TYPE) {
                return Type.BOOLEAN;
            }
            if (clazz == Byte.TYPE) {
                return Type.BYTE;
            }
            if (clazz == Short.TYPE) {
                return Type.SHORT;
            }
            if (clazz == Byte.TYPE) {
                return Type.BYTE;
            }
            if (clazz == Long.TYPE) {
                return Type.LONG;
            }
            if (clazz == Character.TYPE) {
                return Type.CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + clazz);
        }
        return new ObjectType(clazz.getName());
    }
}

