/*
 * Created on 2004. 12. 22.
 */
package net.javajigi.security.web.action;

import java.util.List;

import net.javajigi.security.dao.UserDAO;
import net.javajigi.security.model.User;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import servletunit.struts.MockStrutsTestCase;

/**
 * @author Administrator
 */
public class UserActionTest extends MockStrutsTestCase {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(UserActionTest.class);

	private UserDAO userDAO = null;

	private ApplicationContext ctx = null;
	
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		
		String[] paths = { "/WEB-INF/applicationContext.xml" };
		ctx = new ClassPathXmlApplicationContext(paths);
		userDAO = (UserDAO) ctx.getBean("userDAO");
	}
	
	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		userDAO = null;
	}
	
	private void addUser(String userId) {
	    addUser(userId, "password");
	}
	
	private void addUser(String userId, String password) {
	    if( logger.isDebugEnabled() ) {
	        logger.debug("Starting addUser method!!");
	    }
	    
		setRequestPathInfo("/user");
		addRequestParameter("method", "add");
		addRequestParameter("user.userId", userId);
		addRequestParameter("user.password", password);
		addRequestParameter("user.email", "javajigi@hotmail.com");
		addRequestParameter("user.name", "缺");

		if( logger.isDebugEnabled() ) {
		    logger.debug("Adding new User!!");
		}
		actionPerform();

		verifyForward("list");
		verifyNoActionErrors();
		
		if( logger.isDebugEnabled() ) {
		    logger.debug("End addUser method!!");
		}
	}

	
	private void deleteUser(String userId) {
		setRequestPathInfo("/user");
		addRequestParameter("method", "delete");
		addRequestParameter("userId", userId);
		
		actionPerform();

		verifyForward("list");
		verifyNoActionErrors();
	}	
	
	public void testList() {
		addUser("JavaJiGi");
		
		setRequestPathInfo("/user");
		addRequestParameter("method", "list");
		actionPerform();
		
		verifyForward("list");
		
		verifyNoActionErrors();

		List users = (List) getRequest().getAttribute("userList");
		assertNotNull(users);
		assertTrue(users.size() == 1);
		
		deleteUser("JavaJiGi");
	}
	
	public void testView() {
		addUser("JavaJiGi");
		
		setRequestPathInfo("/user");
		addRequestParameter("method", "view");
		addRequestParameter("userId", "JavaJiGi");
		
		actionPerform();
		verifyForward("view");
		verifyNoActionErrors();

		User user = (User) getRequest().getAttribute("user");
		assertNotNull(user);
		
		deleteUser("JavaJiGi");
	}	
	
	public void testModifyForm() {
		addUser("JavaJiGi");
		
		setRequestPathInfo("/user");
		addRequestParameter("method", "modifyForm");
		addRequestParameter("userId", "JavaJiGi");
		
		actionPerform();
		verifyForward("modify");
		verifyNoActionErrors();

		User user = (User) getRequest().getAttribute("user");
		assertNotNull(user);
		
		deleteUser("JavaJiGi");
	}	
	
    public void testAddAndModify() {
        addUser("JavaJiGi");

        // edit newly added user
        addRequestParameter("method", "modify");
        addRequestParameter("userId", "JavaJiGi");
        actionPerform();
        verifyForward("list");
        verifyNoActionErrors();
        
        deleteUser("JavaJiGi");
    }
}
