/*
 * Created on 2005. 5. 20.
 */
package net.javajigi.security.service;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import net.javajigi.security.model.User;
import junit.framework.TestCase;

/**
 * @author Administrator
 */
public class SecurityBaseTest extends TestCase {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(SecurityBaseTest.class);
	
	private SecurityService service = null;
	
	private UserManager userManager =null;
	
	private ApplicationContext ctx = null;    
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		
		getApplicationContext();
		service = (SecurityService)ctx.getBean("securityService");
		userManager = (UserManager)ctx.getBean("userManager");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		
		service = null;
		userManager = null;
	}

	protected SecurityService getSecurityService() {
	    return this.service;
	}
	
	protected UserManager getUserManager() {
	    return this.userManager;
	}	
	
    /**
     * @param userId TODO
     * @param password TODO
     * @return
     */
    protected User addUser(String userId, String password) {
    	User user = new User();
    	user.setUserId(userId);
    	user.setPassword(password);
    	user.setName("缺");
    	user.setEmail("javajigi@gmail.com");
    
    	if( logger.isDebugEnabled() ) {
    		logger.debug("adding User!!");
    	}
    	userManager.addUser(user);
    	
    	return user;
    }

    /**
     * 
     */
    protected void getApplicationContext() {
    	String[] paths = { "/WEB-INF/applicationContext.xml" };
    	ctx = new ClassPathXmlApplicationContext(paths);
    }

}
