/*
 * Created on 2005. 5. 12.
 */
package net.javajigi.security.web.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.javajigi.security.model.User;
import net.javajigi.security.service.UserManager;

import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

/**
 * @author Administrator
 */
public class UserAction extends DispatchAction {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(UserAction.class);

    private UserManager userManager = null;

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public ActionForward list(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("List User...");
        }

        //      ü
        //request Ͽ ϰ ִ.
        //̰   RequestDispatcher ̿ϱ ̴.
        request.setAttribute("userList", userManager.findUserList());

        return mapping.findForward("list");
    }

    public ActionForward add(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Add User...");
        }

        ActionMessages errors = form.validate(mapping, request);
        if (!errors.isEmpty()) {
            logger.error("Validation Error!!");
            
            saveErrors(request, errors);
            return mapping.findForward("write");
        }

        DynaActionForm userForm = (DynaActionForm) form;
        userManager.addUser((User) userForm.get("user"));
        
        return list(mapping, form, request, response);
    }

    public ActionForward modifyForm(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        findUser(request);

        return mapping.findForward("modify");
    }

    /**
     * @param request
     */
    private void findUser(HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("Finding User...");
        }

        String userId = request.getParameter("userId");

        // null userId indicates an add
        if (userId != null) {
            request.setAttribute("user", userManager.findUser(userId));
        }
    }

    public ActionForward modify(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Modifying User...");
        }

        DynaActionForm userForm = (DynaActionForm) form;
        userManager.updateUser((User) userForm.get("user"));

        return list(mapping, form, request, response);
    }

    public ActionForward view(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        findUser(request);

        return mapping.findForward("view");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Deleting User...");
        }

        String userId = request.getParameter("userId");

        if (userId != null) {
            userManager.removeUser(userId);
        }

        return list(mapping, form, request, response);
    }
}
