/*
 * Created on 2005. 5. 12.
 */
package net.javajigi.security.web.action;

import javax.servlet.ServletContext;

import net.javajigi.security.service.SecurityService;
import net.javajigi.security.service.UserManager;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionServlet;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * @author Administrator
 */
public class BaseAction extends Action {
	private UserManager userManager = null;
	
	private SecurityService securityService = null;
	
	public void setServlet(ActionServlet actionServlet) {
		super.setServlet(actionServlet);
		ServletContext servletContext = actionServlet.getServletContext();
		WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext);
		this.userManager = (UserManager) wac.getBean("userManager");
		this.securityService = (SecurityService)wac.getBean("securityService");
	}

	protected UserManager getUserManager() {
		return userManager;
	}
	
	protected SecurityService getSecurityService() {
		return securityService;
	}
}
