/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.metadata.Attributes;
import org.springframework.transaction.interceptor.AbstractFallbackTransactionAttributeSource;
import org.springframework.util.Assert;

public class AttributesTransactionAttributeSource
extends AbstractFallbackTransactionAttributeSource
implements InitializingBean {
    private Attributes attributes;

    public AttributesTransactionAttributeSource() {
    }

    public AttributesTransactionAttributeSource(Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes is required");
        }
        this.attributes = attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void afterPropertiesSet() {
        if (this.attributes == null) {
            throw new IllegalArgumentException("'attributes' is required");
        }
    }

    protected Collection findAllAttributes(Class clazz) {
        Assert.notNull(this.attributes, "'attributes' is required");
        return this.attributes.getAttributes(clazz);
    }

    protected Collection findAllAttributes(Method method) {
        Assert.notNull(this.attributes, "'attributes' is required");
        return this.attributes.getAttributes(method);
    }
}

