/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink.support;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.TopLinkTemplate;

public abstract class TopLinkDaoSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TopLinkTemplate toplinkTemplate;

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.toplinkTemplate = new TopLinkTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.toplinkTemplate.getSessionFactory();
    }

    public TopLinkTemplate getTopLinkTemplate() {
        return this.toplinkTemplate;
    }

    public void setToplinkTemplate(TopLinkTemplate toplinkTemplate) {
        this.toplinkTemplate = toplinkTemplate;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.toplinkTemplate == null) {
            throw new IllegalArgumentException("sessionFactory or toplinkTemplate is required");
        }
        this.initDao();
    }

    protected void initDao() throws Exception {
    }

    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return this.getSession(this.toplinkTemplate.isAllowCreate());
    }

    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), allowCreate);
    }

    protected final DataAccessException convertToplinkAccessException(TopLinkException ex) {
        return this.toplinkTemplate.convertToplinkAccessException(ex);
    }

    protected final void closeSessionIfNecessary(Session session) throws CleanupFailureDataAccessException {
        SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
    }
}

