/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink.sessions;

import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.Server;
import oracle.toplink.threetier.ServerSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.toplink.sessions.SpringSession;

public class SpringClientSession
extends ClientSession
implements SpringSession {
    private static Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$toplink$sessions$SpringClientSession == null ? (class$org$springframework$orm$toplink$sessions$SpringClientSession = SpringClientSession.class$("org.springframework.orm.toplink.sessions.SpringClientSession")) : class$org$springframework$orm$toplink$sessions$SpringClientSession));
    protected boolean hasTransaction = false;
    protected oracle.toplink.sessions.UnitOfWork unitOfWork = null;
    protected boolean isSynchronized;
    static /* synthetic */ Class class$org$springframework$orm$toplink$sessions$SpringClientSession;

    public void resetTransaction() {
        this.unitOfWork = null;
        this.hasTransaction = false;
    }

    public oracle.toplink.sessions.UnitOfWork getTransaction() {
        if (this.hasTransaction) {
            return this.unitOfWork;
        }
        if (this.hasExternalTransactionController()) {
            logger.debug((Object)"detected an ExternalTransactionController.  TopLink will manage mapping between UnitOfWork and UserTransaction.");
            this.unitOfWork = super.getActiveUnitOfWork();
            if (this.unitOfWork == null) {
                logger.debug((Object)"UnitOfWork not current bound to transaction.  Acquire new synchronized UnitOfWork.");
                this.unitOfWork = super.acquireUnitOfWork();
            }
        } else {
            logger.debug((Object)"acquireUnitOfWork(not managed by TopLink ExternalTransactionController.  Must be managed exclusively by Spring PlatformTransactionManager");
            this.unitOfWork = super.acquireUnitOfWork();
        }
        this.hasTransaction = true;
        if (this.isSynchronized) {
            ((UnitOfWork)this.unitOfWork).setSynchronized();
        }
        return this.unitOfWork;
    }

    public boolean hasTransaction() {
        return this.hasTransaction;
    }

    public UnitOfWork acquireUnitOfWork() {
        return (UnitOfWork)this.getTransaction();
    }

    public oracle.toplink.sessions.UnitOfWork getActiveUnitOfWork() {
        return this.getTransaction();
    }

    public SpringClientSession(Server server, ConnectionPolicy defaultConnectionPolicy) {
        super((ServerSession)server, defaultConnectionPolicy);
    }

    public void release() throws DatabaseException {
        super.release();
        if (this.hasTransaction) {
            this.hasTransaction = false;
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
    }

    public boolean isTransactionSynchronized() {
        return this.isSynchronized;
    }

    public void setTransactionSynchronized() {
        this.isSynchronized = true;
        if (this.hasTransaction && !((UnitOfWork)this.unitOfWork).isSynchronized()) {
            ((UnitOfWork)this.unitOfWork).setSynchronized();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

