/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink.sessions;

import java.io.Writer;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.SessionLog;
import oracle.toplink.sessions.SessionLogEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionLog904
implements SessionLog {
    private Log logger = LogFactory.getLog((String)"toplink");

    public void log(SessionLogEntry entry) {
        Session session = entry.getSession();
        String sessionName = "Session";
        if (session.isUnitOfWork()) {
            sessionName = "UnitOfWork";
        } else if (session.isServerSession()) {
            sessionName = "ServerSession";
        } else if (session.isClientSession()) {
            sessionName = "ClientSession";
        } else if (session.isSessionBroker()) {
            sessionName = "SessionBroker";
        } else if (session.isRemoteSession()) {
            sessionName = "RemoteSession";
        } else if (session.isDatabaseSession()) {
            sessionName = "DatabaseSession";
        }
        String sessionString = sessionName + "(" + String.valueOf(System.identityHashCode(session)) + ")";
        if (entry.isDebug()) {
            this.logger.debug((Object)(sessionString + " " + entry.getMessage()));
        } else if (entry.hasException()) {
            this.logger.warn((Object)(sessionString + " " + entry.getException().getMessage()), (Throwable)entry.getException());
        } else {
            this.logger.info((Object)(sessionString + " " + entry.getMessage()));
        }
    }

    public void setShouldLogDebug(boolean flag) {
    }

    public void setShouldLogExceptions(boolean flag) {
    }

    public void setShouldLogExceptionStackTrace(boolean flag) {
    }

    public void setShouldPrintConnection(boolean flag) {
    }

    public void setShouldPrintDate(boolean flag) {
    }

    public void setShouldPrintSession(boolean flag) {
    }

    public void setShouldPrintThread(boolean flag) {
    }

    public Writer getWriter() {
        return null;
    }

    public void setWriter(Writer log) {
    }

    public boolean shouldLogDebug() {
        return false;
    }

    public boolean shouldLogExceptions() {
        return false;
    }

    public boolean shouldLogExceptionStackTrace() {
        return false;
    }

    public boolean shouldPrintConnection() {
        return false;
    }

    public boolean shouldPrintDate() {
        return false;
    }

    public boolean shouldPrintSession() {
        return false;
    }

    public boolean shouldPrintThread() {
        return false;
    }
}

