/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink.sessions;

import oracle.toplink.sessions.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.toplink.sessions.SpringSession;
import org.springframework.transaction.support.ResourceHolderSupport;

public class SessionHolder
extends ResourceHolderSupport {
    private final SpringSession session;
    private boolean synchronizedWithTransaction;
    private boolean hasTransaction = false;
    private final Log log = LogFactory.getLog(this.getClass());

    public SessionHolder(Session session) {
        this.session = (SpringSession)session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSynchronizedWithTransaction(boolean synchronizedWithTransaction) {
        this.synchronizedWithTransaction = synchronizedWithTransaction;
    }

    public boolean isSynchronizedWithTransaction() {
        return this.synchronizedWithTransaction;
    }

    public Object getTransaction() {
        return this.session.getActiveUnitOfWork();
    }

    public void resetTransaction() {
        if (this.hasTransaction()) {
            this.session.resetTransaction();
        }
        this.hasTransaction = false;
    }

    public void transactionStarted() {
        this.hasTransaction = true;
    }

    public boolean hasTransaction() {
        return this.hasTransaction;
    }
}

