/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.sql.SQLException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.exceptions.TopLinkJdbcException;
import org.springframework.orm.toplink.sessions.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TopLinkTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private SessionFactory sessionFactory;
    private SQLExceptionTranslator jdbcExceptionTranslator = new SQLStateSQLExceptionTranslator();

    public TopLinkTransactionManager() {
    }

    public TopLinkTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("TopLinkSessionFactory is required");
        }
    }

    protected Object doGetTransaction() {
        if (TransactionSynchronizationManager.hasResource(this.sessionFactory)) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.sessionFactory);
            this.logger.debug((Object)("Found thread-bound session [" + sessionHolder.getSession() + "] for Toplink transaction"));
            return new TransactionObject(sessionHolder);
        }
        this.logger.debug((Object)"No thread-bound Session found.  Create empty TransactionObject");
        return new TransactionObject();
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((TransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        Session session;
        TransactionObject txObject = (TransactionObject)transaction;
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (txObject.getSessionHolder() == null) {
            session = SessionFactoryUtils.getSession(this.sessionFactory, false, true);
            if (debugEnabled) {
                this.logger.debug((Object)("Opened new session [" + session + "] for Toplink transaction"));
            }
            txObject.setSessionHolder(new SessionHolder(session));
        }
        try {
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
            session = txObject.getSessionHolder().getSession();
            if (debugEnabled) {
                this.logger.debug((Object)("Beginning Toplink transaction on session [" + session + "]"));
            }
            if (txObject.isNewSessionHolder() && definition.isReadOnly()) {
                this.logger.debug((Object)"this transaction is marked read-only so the UOW will not commit");
            }
            switch (definition.getIsolationLevel()) {
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            if (definition.getTimeout() != -1) {
                txObject.getSessionHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            txObject.getSessionHolder().transactionStarted();
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource(this.sessionFactory, txObject.getSessionHolder());
            }
        }
        catch (TopLinkException ex) {
            throw new CannotCreateTransactionException("Could not create Toplink transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        TransactionObject txObject = (TransactionObject)transaction;
        txObject.setSessionHolder(null);
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.sessionFactory);
        return sessionHolder;
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SessionHolder sessionHolder = (SessionHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource(this.sessionFactory)) {
            TransactionSynchronizationManager.unbindResource(this.sessionFactory);
        }
        TransactionSynchronizationManager.bindResource(this.sessionFactory, sessionHolder);
    }

    protected boolean isRollbackOnly(Object transaction) {
        return ((TransactionObject)transaction).getSessionHolder().isRollbackOnly();
    }

    protected void doCommit(DefaultTransactionStatus status) {
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Toplink transaction on session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            if (!status.isReadOnly()) {
                UnitOfWork uow = (UnitOfWork)txObject.getSessionHolder().getTransaction();
                uow.commit();
            }
            txObject.getSessionHolder().resetTransaction();
            txObject.getSessionHolder().clear();
        }
        catch (DatabaseException ex) {
            throw this.convertJdbcAccessException((SQLException)ex.getInternalException());
        }
        catch (TopLinkException ex) {
            throw this.convertToplinkAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        this.logger.debug((Object)"operation on current uow has been rolled back");
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        txObject.getSessionHolder().resetTransaction();
        txObject.getSessionHolder().clear();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        TransactionObject txObject = (TransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Toplink transaction on Session [" + txObject.getSessionHolder().getSession() + "] rollback-only"));
        }
        txObject.getSessionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionObject txObject = (TransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.sessionFactory);
        }
        Session session = txObject.getSessionHolder().getSession();
        if (txObject.isNewSessionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Toplink session [" + session + "] after transaction"));
            }
            try {
                SessionFactoryUtils.closeSessionIfNecessary(session, this.sessionFactory);
            }
            catch (CleanupFailureDataAccessException ex) {
                this.logger.error((Object)"Count not close Toplink session after transaction", (Throwable)ex);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Not closing pre-bound Toplink session [" + session + "] after transaction"));
        }
    }

    protected DataAccessException convertToplinkAccessException(TopLinkException ex) {
        return SessionFactoryUtils.convertToplinkAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        if (this.jdbcExceptionTranslator != null) {
            return this.jdbcExceptionTranslator.translate("ToplinkTemplate", null, ex);
        }
        return new TopLinkJdbcException(ex);
    }

    private static class TransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;

        protected TransactionObject() {
        }

        protected TransactionObject(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = false;
        }

        protected void setSessionHolder(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = sessionHolder != null;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean hasTransaction() {
            return this.sessionHolder != null && this.sessionHolder.hasTransaction();
        }

        public boolean isRollbackOnly() {
            return this.getSessionHolder().isRollbackOnly();
        }
    }
}

