/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.sql.SQLException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.exceptions.TopLinkJdbcException;

public abstract class TopLinkAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;
    private SQLExceptionTranslator jdbcExceptionTranslator = new SQLStateSQLExceptionTranslator();

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("Toplink sessionFactory is required");
        }
    }

    public DataAccessException convertToplinkAccessException(TopLinkException ex) {
        Exception internalEx;
        if (ex instanceof DatabaseException && (internalEx = ex.getInternalException()) != null && internalEx instanceof SQLException) {
            return this.convertJdbcAccessException((SQLException)internalEx);
        }
        return SessionFactoryUtils.convertToplinkAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        if (this.jdbcExceptionTranslator != null) {
            return this.jdbcExceptionTranslator.translate("ToplinkAccessor", null, ex);
        }
        return new TopLinkJdbcException(ex);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

