/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.jts.AbstractExternalTransactionController;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sessions.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.exceptions.TopLinkJdbcException;
import org.springframework.orm.toplink.exceptions.TopLinkOptimisticLockingFailureException;
import org.springframework.orm.toplink.exceptions.TopLinkQueryException;
import org.springframework.orm.toplink.exceptions.TopLinkSystemException;
import org.springframework.orm.toplink.exceptions.TopLinkTypeMismatchDataAccessException;
import org.springframework.orm.toplink.sessions.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class SessionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$toplink$SessionFactoryUtils == null ? (class$org$springframework$orm$toplink$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.toplink.SessionFactoryUtils")) : class$org$springframework$orm$toplink$SessionFactoryUtils));
    static /* synthetic */ Class class$org$springframework$orm$toplink$SessionFactoryUtils;

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(sessionFactory, true, allowCreate);
    }

    public static Session getSession(SessionFactory sessionFactory, boolean allowSynchronization, boolean allowCreate) throws DataAccessResourceFailureException {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        if (sessionHolder != null) {
            logger.debug((Object)"found SessionHolder bound to Session");
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                if (allowSynchronization && !sessionHolder.isSynchronizedWithTransaction()) {
                    logger.debug((Object)"no Synchronization registered.  Registering new Synchronization with existing Session.");
                    TransactionSynchronizationManager.registerSynchronization(new SpringSessionSynchronization(sessionHolder, sessionFactory, null, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                } else {
                    logger.debug((Object)"not registered synchronization for pre-bound Session");
                }
            }
            return sessionHolder.getSession();
        }
        if (!allowCreate) {
            throw new IllegalStateException("No Toplink Session bound to thread, and configuration does not allow creation of new one here");
        }
        logger.debug((Object)"Opening Toplink session");
        try {
            Session session = sessionFactory.createSession();
            if (allowSynchronization) {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    logger.debug((Object)"Registering new Spring transaction synchronization for new Toplink session");
                    sessionHolder = new SessionHolder(session);
                    TransactionSynchronizationManager.registerSynchronization(new SpringSessionSynchronization(sessionHolder, sessionFactory, null, true));
                    TransactionSynchronizationManager.bindResource(sessionFactory, sessionHolder);
                    sessionHolder.setSynchronizedWithTransaction(true);
                } else if (session.hasExternalTransactionController()) {
                    logger.debug((Object)"register a JTA Synchronization to clean up Thread-bound resources");
                    AbstractExternalTransactionController etc = (AbstractExternalTransactionController)session.getExternalTransactionController();
                    sessionHolder = new SessionHolder(session);
                    try {
                        Transaction transaction = (Transaction)etc.getExternalTransaction();
                        transaction.registerSynchronization((Synchronization)new JTASessionSynchronization(sessionFactory, sessionHolder, true));
                        sessionHolder.setSynchronizedWithTransaction(true);
                        TransactionSynchronizationManager.bindResource(sessionFactory, sessionHolder);
                        sessionHolder.setSynchronizedWithTransaction(true);
                    }
                    catch (Exception e) {
                        logger.error((Object)"unable to register listener with JTA Transaction", (Throwable)e);
                        throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", e);
                    }
                } else {
                    logger.debug((Object)"not registering synchronization because synchronizations are not initialized");
                }
            } else {
                logger.debug((Object)"not registering Synchronization or binding SessionHolder to Thread");
            }
            return session;
        }
        catch (DatabaseException ex) {
            throw new DataAccessResourceFailureException("Could not open Toplink session", ex.getInternalException());
        }
        catch (TopLinkException ex) {
            throw new DataAccessResourceFailureException("Could not open Toplink session", ex);
        }
    }

    public static void applyTransactionTimeout(DatabaseQuery query, Session session) {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(session);
        if (sessionHolder != null && sessionHolder.getDeadline() != null) {
            query.setQueryTimeout((long)sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertToplinkAccessException(TopLinkException ex) {
        if (ex instanceof DatabaseException) {
            return new TopLinkJdbcException((DatabaseException)((Object)ex));
        }
        if (ex instanceof ConcurrencyException) {
            return new TopLinkSystemException(ex);
        }
        if (ex instanceof ConversionException) {
            return new TopLinkTypeMismatchDataAccessException(ex.getMessage(), ex);
        }
        if (ex instanceof QueryException) {
            return new TopLinkQueryException((QueryException)ex);
        }
        if (ex instanceof OptimisticLockException) {
            return new TopLinkOptimisticLockingFailureException((OptimisticLockException)ex);
        }
        return new TopLinkSystemException(ex);
    }

    public static void closeSessionIfNecessary(Session session, SessionFactory sessionFactory) throws CleanupFailureDataAccessException {
        if (session == null || TransactionSynchronizationManager.hasResource(sessionFactory)) {
            return;
        }
        logger.debug((Object)("Closing Toplink session " + session));
        try {
            session.release();
        }
        catch (DatabaseException ex) {
            throw new CleanupFailureDataAccessException("Could not close Toplink session", ex.getInternalException());
        }
        catch (TopLinkException ex) {
            throw new CleanupFailureDataAccessException("Could not close Toplink session", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JTASessionSynchronization
    implements Synchronization {
        private final SessionFactory sessionFactory;
        private final SessionHolder sessionHolder;
        private final boolean newSession;

        private JTASessionSynchronization(SessionFactory sessionFactory, SessionHolder sessionHolder, boolean newSession) {
            this.sessionFactory = sessionFactory;
            this.sessionHolder = sessionHolder;
            this.newSession = newSession;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.newSession) {
                TransactionSynchronizationManager.unbindResource(this.sessionFactory);
            }
            Session session = this.sessionHolder.getSession();
            if (this.newSession) {
                SessionFactoryUtils.closeSessionIfNecessary(session, this.sessionFactory);
            }
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }

    private static class SpringSessionSynchronization
    implements TransactionSynchronization {
        private final SessionHolder sessionHolder;
        private final SessionFactory sessionFactory;
        private final SQLExceptionTranslator jdbcExceptionTranslator;
        private final boolean newSession;

        private SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean newSession) {
            this.sessionHolder = sessionHolder;
            this.sessionFactory = sessionFactory;
            this.jdbcExceptionTranslator = jdbcExceptionTranslator;
            this.newSession = newSession;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource(this.sessionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource(this.sessionFactory, this.sessionHolder);
        }

        public void beforeCommit(boolean readOnly) throws DataAccessException {
        }

        public void beforeCompletion() throws CleanupFailureDataAccessException {
            if (this.newSession) {
                TransactionSynchronizationManager.unbindResource(this.sessionFactory);
            }
        }

        public void afterCompletion(int status) {
            Session session = this.sessionHolder.getSession();
            if (this.newSession) {
                SessionFactoryUtils.closeSessionIfNecessary(session, this.sessionFactory);
            }
            this.sessionHolder.setSynchronizedWithTransaction(false);
            this.sessionHolder.clear();
            this.sessionHolder.resetTransaction();
        }
    }
}

