/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.TransactionException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements BeanFactoryAware,
InitializingBean {
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private Object entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$net$sf$hibernate$Interceptor;

    public HibernateTransactionManager() {
    }

    public HibernateTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean autodetectDataSource) {
        this.autodetectDataSource = autodetectDataSource;
    }

    public void setEntityInterceptorBeanName(String entityInterceptorBeanName) {
        this.entityInterceptor = entityInterceptorBeanName;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptor instanceof Interceptor) {
            return (Interceptor)this.entityInterceptor;
        }
        if (this.entityInterceptor instanceof String) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            String beanName = (String)this.entityInterceptor;
            return (Interceptor)this.beanFactory.getBean(beanName, class$net$sf$hibernate$Interceptor == null ? (class$net$sf$hibernate$Interceptor = HibernateTransactionManager.class$("net.sf.hibernate.Interceptor")) : class$net$sf$hibernate$Interceptor);
        }
        return null;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        if (this.jdbcExceptionTranslator == null) {
            this.jdbcExceptionTranslator = this.getDataSource() != null ? new SQLErrorCodeSQLExceptionTranslator(this.getDataSource()) : SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.jdbcExceptionTranslator;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        DataSource sfds;
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
        if (this.entityInterceptor instanceof String && this.beanFactory == null) {
            throw new IllegalArgumentException("beanFactory is required for entityInterceptorBeanName");
        }
        if (this.autodetectDataSource && this.getDataSource() == null && (sfds = SessionFactoryUtils.getDataSource(this.getSessionFactory())) != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using DataSource [" + sfds + "] of Hibernate SessionFactory for HibernateTransactionManager"));
            }
            this.setDataSource(sfds);
        }
    }

    protected Object doGetTransaction() {
        HibernateTransactionObject txObject = new HibernateTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getSessionFactory());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound session [" + sessionHolder.getSession() + "] for Hibernate transaction"));
            }
            txObject.setSessionHolder(sessionHolder, false);
            if (this.getDataSource() != null) {
                ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getDataSource());
                txObject.setConnectionHolder(conHolder);
            }
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((HibernateTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        Session session;
        if (this.getDataSource() != null && TransactionSynchronizationManager.hasResource(this.getDataSource())) {
            throw new IllegalTransactionStateException("Pre-bound JDBC connection found - HibernateTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single HibernateTransactionManager for all transactions on a single DataSource, no matter whether Hibernate or JDBC access.");
        }
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        if (txObject.getSessionHolder() == null) {
            session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator(), false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Opened new session [" + session + "] for Hibernate transaction"));
            }
            txObject.setSessionHolder(new SessionHolder(session), true);
        }
        txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        session = txObject.getSessionHolder().getSession();
        try {
            FlushMode flushMode;
            Connection con = session.connection();
            Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction(con, definition);
            txObject.setPreviousIsolationLevel(previousIsolationLevel);
            if (definition.isReadOnly() && txObject.isNewSessionHolder()) {
                session.setFlushMode(FlushMode.NEVER);
            }
            if (!definition.isReadOnly() && !txObject.isNewSessionHolder() && FlushMode.NEVER.equals(flushMode = session.getFlushMode())) {
                session.setFlushMode(FlushMode.AUTO);
                txObject.getSessionHolder().setPreviousFlushMode(flushMode);
            }
            txObject.getSessionHolder().setTransaction(session.beginTransaction());
            if (definition.getTimeout() != -1) {
                txObject.getSessionHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            if (this.getDataSource() != null) {
                ConnectionHolder conHolder = new ConnectionHolder(con);
                if (definition.getTimeout() != -1) {
                    conHolder.setTimeoutInSeconds(definition.getTimeout());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing Hibernate transaction as JDBC transaction [" + conHolder.getConnection() + "]"));
                }
                TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource(this.getSessionFactory(), txObject.getSessionHolder());
            }
        }
        catch (Exception ex) {
            SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
            throw new CannotCreateTransactionException("Could not create Hibernate transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        txObject.setSessionHolder(null, false);
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource(this.getSessionFactory(), resourcesHolder.getSessionHolder());
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), resourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Hibernate transaction on session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", ex);
        }
        catch (JDBCException ex) {
            throw this.convertJdbcAccessException(ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Hibernate transaction on session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().rollback();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not roll back Hibernate transaction", ex);
        }
        catch (JDBCException ex) {
            throw this.convertJdbcAccessException(ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        finally {
            if (!txObject.isNewSessionHolder()) {
                txObject.getSessionHolder().getSession().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Hibernate transaction on session [" + txObject.getSessionHolder().getSession() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        try {
            Connection con = txObject.getSessionHolder().getSession().connection();
            DataSourceUtils.resetConnectionAfterTransaction(con, txObject.getPreviousIsolationLevel());
        }
        catch (HibernateException ex) {
            this.logger.info((Object)"Could not access JDBC connection of Hibernate session", (Throwable)ex);
        }
        Session session = txObject.getSessionHolder().getSession();
        if (txObject.isNewSessionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Hibernate session [" + session + "] after transaction"));
            }
            SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not closing pre-bound Hibernate session [" + session + "] after transaction"));
            }
            if (txObject.getSessionHolder().getPreviousFlushMode() != null) {
                session.setFlushMode(txObject.getSessionHolder().getPreviousFlushMode());
            }
        }
        txObject.getSessionHolder().clear();
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        if (this.getJdbcExceptionTranslator() != null) {
            return this.getJdbcExceptionTranslator().translate("HibernateTemplate", null, ex);
        }
        return new HibernateJdbcException(ex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder conHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = conHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }

    private static class HibernateTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;

        private HibernateTransactionObject() {
        }

        public void setSessionHolder(SessionHolder sessionHolder, boolean newSessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = newSessionHolder;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean hasTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public void setRollbackOnly() {
            this.getSessionHolder().setRollbackOnly();
            if (this.getConnectionHolder() != null) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.getSessionHolder().isRollbackOnly() || this.getConnectionHolder() != null && this.getConnectionHolder().isRollbackOnly();
        }
    }
}

