/*
 * Decompiled with CFR 0.152.
 */
package servletunit.struts;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import junit.framework.AssertionFailedError;
import org.apache.cactus.ServletTestCase;
import org.apache.cactus.server.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionServlet;
import servletunit.struts.Common;
import servletunit.struts.ExceptionDuringTestError;
import servletunit.struts.StrutsRequestWrapper;
import servletunit.struts.StrutsResponseWrapper;
import servletunit.struts.StrutsServletConfigWrapper;
import servletunit.struts.StrutsServletContextWrapper;

public class CactusStrutsTestCase
extends ServletTestCase {
    protected ActionServlet actionServlet;
    protected javax.servlet.http.HttpServletRequestWrapper requestWrapper;
    protected HttpServletResponseWrapper responseWrapper;
    protected boolean isInitialized = false;
    protected boolean actionServletIsInitialized = false;
    protected boolean requestPathIsSet = false;
    protected String moduleName;
    protected String servletMapping = "*.do";
    protected static Log logger = LogFactory.getLog((Class)(class$servletunit$struts$CactusStrutsTestCase == null ? (class$servletunit$struts$CactusStrutsTestCase = CactusStrutsTestCase.class$("servletunit.struts.CactusStrutsTestCase")) : class$servletunit$struts$CactusStrutsTestCase));
    static /* synthetic */ Class class$servletunit$struts$CactusStrutsTestCase;

    public CactusStrutsTestCase() {
    }

    public CactusStrutsTestCase(String testName) {
        super(testName);
    }

    private void init() {
        if (!this.isInitialized) {
            throw new AssertionFailedError("You are overriding the setUp() method without calling super.setUp().  You must call the superclass setUp() and tearDown() methods in your TestCase subclass to ensure proper initialization.");
        }
    }

    protected void setUp() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        try {
            if (this.actionServlet == null) {
                this.actionServlet = new ActionServlet();
            }
            this.requestWrapper = null;
            this.responseWrapper = null;
            StrutsServletContextWrapper servletContext = new StrutsServletContextWrapper(this.config.getServletContext());
            this.config = new StrutsServletConfigWrapper((ServletConfig)this.config);
            ((StrutsServletConfigWrapper)this.config).setServletContext((ServletContext)servletContext);
            this.request = new StrutsRequestWrapper(this.request);
            this.response = new StrutsResponseWrapper(this.response);
            this.isInitialized = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            throw new AssertionFailedError("Error trying to set up test fixture: " + e.getClass() + " - " + e.getMessage());
        }
    }

    public void setServletMapping(String servletMapping) {
        this.servletMapping = servletMapping;
    }

    protected void tearDown() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering");
        }
        ServletContext context = this.config.getServletContext();
        ArrayList<String> nameList = new ArrayList<String>();
        Enumeration attributeNames = context.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            if (!name.startsWith("org.apache.struts.action.REQUEST_PROCESSOR")) continue;
            nameList.add(name);
        }
        ServletConfig originalConfig = this.config.getOriginalConfig();
        ServletContext originalContext = originalConfig.getServletContext();
        originalContext.setAttribute("org.apache.struts.action.SERVLET_MAPPING", (Object)this.servletMapping);
        ((StrutsServletConfigWrapper)this.config).setServletContext(originalContext);
        Iterator iterator = nameList.iterator();
        while (iterator.hasNext()) {
            context.removeAttribute((String)iterator.next());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    public HttpServletRequest getRequest() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.request;
    }

    public javax.servlet.http.HttpServletRequestWrapper getRequestWrapper() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (this.requestWrapper == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
            return new javax.servlet.http.HttpServletRequestWrapper((HttpServletRequest)this.request);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("wrapper class is '" + this.requestWrapper.getClass() + "'"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.requestWrapper;
    }

    public void setRequestWrapper(javax.servlet.http.HttpServletRequestWrapper wrapper) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - wrapper = " + wrapper));
        }
        this.init();
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper class cannot be null!");
        }
        if (wrapper.getRequest() == null) {
            wrapper.setRequest((ServletRequest)this.request);
        }
        this.requestWrapper = wrapper;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public HttpServletResponse getResponse() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.response;
    }

    public HttpServletResponseWrapper getResponseWrapper() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (this.responseWrapper == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting getResponseWrapper()");
            }
            return new HttpServletResponseWrapper(this.response);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("wrapper class is '" + this.responseWrapper.getClass() + "'"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getResponseWrapper()");
        }
        return this.responseWrapper;
    }

    public void setResponseWrapper(HttpServletResponseWrapper wrapper) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - wrapper = " + wrapper.getClass()));
        }
        this.init();
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper class cannot be null!");
        }
        if (wrapper.getResponse() == null) {
            wrapper.setResponse((ServletResponse)this.response);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        this.responseWrapper = wrapper;
    }

    public HttpSession getSession() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return this.session;
    }

    public void addRequestParameter(String parameterName, String parameterValue) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - paramaterName = " + parameterName + ", parameterValue = " + parameterValue));
        }
        this.init();
        ((StrutsRequestWrapper)this.request).addParameter(parameterName, parameterValue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void addRequestParameter(String parameterName, String[] parameterValues) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - paramaterName = " + parameterName + ", parameterValue = " + parameterValues));
        }
        this.init();
        ((StrutsRequestWrapper)this.request).addParameter(parameterName, parameterValues);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void clearRequestParameters() {
        this.init();
        ((StrutsRequestWrapper)this.request).clearRequestParameters();
    }

    public void setRequestPathInfo(String pathInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - pathInfo = " + pathInfo));
        }
        this.init();
        this.setRequestPathInfo("", pathInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setRequestPathInfo(String moduleName, String pathInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - moduleName = " + moduleName + ", pathInfo = " + pathInfo));
        }
        this.init();
        ((StrutsRequestWrapper)this.request).setPathInfo(Common.stripActionPath(pathInfo));
        if (moduleName != null) {
            if (!moduleName.equals("")) {
                if (!moduleName.startsWith("/")) {
                    moduleName = "/" + moduleName;
                }
                if (!moduleName.endsWith("/")) {
                    moduleName = moduleName + "/";
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setting request.ServletPath value = " + moduleName));
            }
            ((StrutsRequestWrapper)this.request).setServletPath(moduleName);
            this.requestPathIsSet = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setInitParameter(String key, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering -  key = " + key + ", value = " + value));
        }
        this.config.setInitParameter(key, value);
        this.actionServletIsInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setConfigFile(String pathname) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - pathname = " + pathname));
        }
        this.init();
        this.setConfigFile(null, pathname);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void setConfigFile(String moduleName, String pathname) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - moduleName = " + moduleName + ", pathname = " + pathname));
        }
        this.init();
        if (moduleName == null) {
            this.config.setInitParameter("config", pathname);
        } else {
            this.config.setInitParameter("config/" + moduleName, pathname);
        }
        this.actionServletIsInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public ActionServlet getActionServlet() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        try {
            if (!this.actionServletIsInitialized) {
                String moduleName;
                String name;
                ServletContext context = this.config.getServletContext();
                Object obj = context.getAttribute(name = "org.apache.struts.action.REQUEST_PROCESSOR");
                if (obj != null) {
                    this.config.getServletContext().removeAttribute(name);
                }
                String string = moduleName = this.request.getServletPath() != null ? this.request.getServletPath() : "";
                if (moduleName.endsWith("/")) {
                    moduleName = moduleName.substring(0, moduleName.lastIndexOf("/"));
                }
                if ((obj = context.getAttribute(name + moduleName)) != null) {
                    this.config.getServletContext().removeAttribute(name + moduleName);
                }
                this.actionServlet.init((ServletConfig)this.config);
                this.actionServletIsInitialized = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
            return this.actionServlet;
        }
        catch (ServletException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error in getActionServlet()", e.getRootCause());
            }
            throw new AssertionFailedError("Error while initializing ActionServlet: " + e.getMessage());
        }
    }

    public void setActionServlet(ActionServlet servlet) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - servlet = " + servlet));
        }
        this.init();
        if (servlet == null) {
            throw new AssertionFailedError("Cannot set ActionServlet to null");
        }
        this.actionServlet = servlet;
        this.actionServletIsInitialized = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void actionPerform() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        if (!this.requestPathIsSet) {
            throw new IllegalStateException("You must call setRequestPathInfo() prior to calling actionPerform().");
        }
        this.init();
        try {
            HttpServletRequestWrapper request = this.request;
            HttpServletResponse response = this.response;
            request.removeAttribute("org.apache.struts.action.ERROR");
            request.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
            if (this.requestWrapper != null) {
                request = this.requestWrapper;
            }
            if (this.responseWrapper != null) {
                response = this.responseWrapper;
            }
            ActionServlet actionServlet = this.getActionServlet();
            actionServlet.doPost((HttpServletRequest)request, response);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
        }
        catch (NullPointerException npe) {
            String message = "A NullPointerException was thrown.  This may indicate an error in your ActionForm, or it may indicate that the Struts ActionServlet was unable to find struts config file.  TestCase is running from " + System.getProperty("user.dir") + " directory.";
            throw new ExceptionDuringTestError(message, npe);
        }
        catch (Exception e) {
            throw new ExceptionDuringTestError("An uncaught exception was thrown during actionExecute()", e);
        }
    }

    protected String getActualForward() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        if (this.response.containsHeader("Location")) {
            return Common.stripJSessionID(((StrutsResponseWrapper)this.response).getRedirectLocation());
        }
        String forward = ((StrutsServletContextWrapper)this.actionServlet.getServletContext()).getForward();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("actual forward = " + forward));
        }
        if (forward == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exiting");
            }
            return null;
        }
        String temp = Common.stripJSessionID(forward);
        if (!temp.startsWith("/")) {
            temp = "/" + temp;
        }
        String strippedForward = this.request.getContextPath() + temp;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("stripped forward and added context path = " + strippedForward));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return strippedForward;
    }

    public void verifyForward(String forwardName) throws AssertionFailedError {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - forwardName = " + forwardName));
        }
        this.init();
        Common.verifyForwardPath(this.request.getPathInfo(), forwardName, this.getActualForward(), false, (HttpServletRequest)this.request, this.config.getServletContext(), (ServletConfig)this.config);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyForwardPath(String forwardPath) throws AssertionFailedError {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - forwardPath = " + forwardPath));
        }
        this.init();
        String actualForward = this.getActualForward();
        if (actualForward == null && forwardPath == null) {
            return;
        }
        forwardPath = this.request.getContextPath() + forwardPath;
        if (actualForward == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"actualForward is null - this usually means it is not mapped properly.");
            }
            throw new AssertionFailedError("Was expecting '" + forwardPath + "' but it appears the Action has tried to return an ActionForward that is not mapped correctly.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("expected forward = '" + forwardPath + "' - actual forward = '" + actualForward + "'"));
        }
        if (!actualForward.equals(forwardPath)) {
            throw new AssertionFailedError("was expecting '" + forwardPath + "' but received '" + actualForward + "'");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyInputForward() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        Common.verifyForwardPath(this.request.getPathInfo(), null, this.getActualForward(), true, (HttpServletRequest)this.request, this.config.getServletContext(), (ServletConfig)this.config);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyTilesForward(String forwardName, String definitionName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - forwardName=" + forwardName + ", definitionName=" + definitionName));
        }
        this.init();
        Common.verifyTilesForward(this.request.getPathInfo(), forwardName, definitionName, false, (HttpServletRequest)this.request, this.config.getServletContext(), (ServletConfig)this.config);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    public void verifyInputTilesForward(String definitionName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - defintionName=" + definitionName));
        }
        this.init();
        Common.verifyTilesForward(this.request.getPathInfo(), null, definitionName, true, (HttpServletRequest)this.request, this.config.getServletContext(), (ServletConfig)this.config);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    public void verifyActionErrors(String[] errorNames) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - errorNames = " + errorNames));
        }
        this.init();
        Common.verifyActionMessages((HttpServletRequest)this.request, errorNames, "org.apache.struts.action.ERROR", "error");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyNoActionErrors() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        Common.verifyNoActionMessages((HttpServletRequest)this.request, "org.apache.struts.action.ERROR", "error");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyActionMessages(String[] messageNames) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - messageNames = " + messageNames));
        }
        this.init();
        Common.verifyActionMessages((HttpServletRequest)this.request, messageNames, "org.apache.struts.action.ACTION_MESSAGE", "action");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void verifyNoActionMessages() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        Common.verifyNoActionMessages((HttpServletRequest)this.request, "org.apache.struts.action.ACTION_MESSAGE", "action");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public ActionForm getActionForm() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
        return Common.getActionForm(this.request.getPathInfo(), (HttpServletRequest)this.request, this.config.getServletContext());
    }

    public void setActionForm(ActionForm form) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering - form = " + form));
        }
        this.init();
        Common.setActionForm(form, (HttpServletRequest)this.request, this.request.getPathInfo(), this.config.getServletContext());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting");
        }
    }

    public void processRequest(boolean flag) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Entering - flag=" + flag));
        }
        ((StrutsServletContextWrapper)this.config.getServletContext()).setProcessRequest(flag);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Exiting");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

