/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.util.HashMap;
import org.apache.commons.digester.plugins.Declaration;
import org.apache.commons.digester.plugins.LogUtils;
import org.apache.commons.logging.Log;

public class PluginManager {
    private HashMap declarationsByClass = new HashMap();
    private HashMap declarationsById = new HashMap();
    private PluginManager parent;

    public PluginManager() {
    }

    public PluginManager(PluginManager parent) {
        this.parent = parent;
    }

    public void addDeclaration(Declaration decl) {
        Log log = LogUtils.getLogger(null);
        boolean debug = log.isDebugEnabled();
        Class pluginClass = decl.getPluginClass();
        String id = decl.getId();
        this.declarationsByClass.put(pluginClass.getName(), decl);
        if (id != null) {
            this.declarationsById.put(id, decl);
            if (debug) {
                log.debug((Object)("Indexing plugin-id [" + id + "]" + " -> class [" + pluginClass.getName() + "]"));
            }
        }
    }

    public Declaration getDeclarationByClass(String className) {
        Declaration decl = (Declaration)this.declarationsByClass.get(className);
        if (decl == null && this.parent != null) {
            decl = this.parent.getDeclarationByClass(className);
        }
        return decl;
    }

    public Declaration getDeclarationById(String id) {
        Declaration decl = (Declaration)this.declarationsById.get(id);
        if (decl == null && this.parent != null) {
            decl = this.parent.getDeclarationById(id);
        }
        return decl;
    }
}

