/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.plugins.Declaration;
import org.apache.commons.digester.plugins.InitializableRule;
import org.apache.commons.digester.plugins.LogUtils;
import org.apache.commons.digester.plugins.PluginAssertionFailure;
import org.apache.commons.digester.plugins.PluginConfigurationException;
import org.apache.commons.digester.plugins.PluginInvalidInputException;
import org.apache.commons.digester.plugins.PluginManager;
import org.apache.commons.digester.plugins.PluginRules;
import org.apache.commons.digester.plugins.PluginWrappedException;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class PluginCreateRule
extends Rule
implements InitializableRule {
    public static final String GLOBAL_PLUGIN_CLASS_ATTR_NS = null;
    public static final String GLOBAL_PLUGIN_CLASS_ATTR = "plugin-class";
    public static final String GLOBAL_PLUGIN_ID_ATTR_NS = null;
    public static final String GLOBAL_PLUGIN_ID_ATTR = "plugin-id";
    private static String globalPluginClassAttrNs = GLOBAL_PLUGIN_CLASS_ATTR_NS;
    private static String globalPluginClassAttr = "plugin-class";
    private static String globalPluginIdAttrNs = GLOBAL_PLUGIN_ID_ATTR_NS;
    private static String globalPluginIdAttr = "plugin-id";
    private String pluginClassAttrNs = globalPluginClassAttrNs;
    private String pluginClassAttr = globalPluginClassAttr;
    private String pluginIdAttrNs = globalPluginIdAttrNs;
    private String pluginIdAttr = globalPluginIdAttr;
    private String pattern;
    private Class baseClass = null;
    private Declaration defaultPlugin;
    private PluginConfigurationException initException;
    private PluginRules localRules;
    static /* synthetic */ Class class$java$lang$Object;

    public static void setGlobalPluginClassAttribute(String namespaceUri, String attrName) {
        globalPluginClassAttrNs = namespaceUri;
        globalPluginClassAttr = attrName;
    }

    public static void setGlobalPluginIdAttribute(String namespaceUri, String attrName) {
        globalPluginIdAttrNs = namespaceUri;
        globalPluginIdAttr = attrName;
    }

    public PluginCreateRule(Class baseClass) {
        this.baseClass = baseClass;
    }

    public PluginCreateRule(Class baseClass, Class dfltPluginClass) {
        this.baseClass = baseClass;
        if (dfltPluginClass != null) {
            this.defaultPlugin = new Declaration(dfltPluginClass);
        }
    }

    public void setDefaultRuleMethod(String dfltPluginRuleMethod) {
        if (this.defaultPlugin != null) {
            this.defaultPlugin.setRuleMethod(dfltPluginRuleMethod);
        }
    }

    public void setDefaultRuleClass(Class dfltPluginRuleClass) {
        if (this.defaultPlugin != null) {
            this.defaultPlugin.setRuleClass(dfltPluginRuleClass);
        }
    }

    public void setDefaultRuleResource(String dfltPluginRuleResource) {
        if (this.defaultPlugin != null) {
            this.defaultPlugin.setRuleResource(dfltPluginRuleResource);
        }
    }

    public void setDefaultRuleFile(String dfltPluginRuleFile) {
        if (this.defaultPlugin != null) {
            this.defaultPlugin.setRuleFile(new File(dfltPluginRuleFile));
        }
    }

    public void setDefaultRuleAutoSetProperties(boolean enabled) {
        if (this.defaultPlugin != null) {
            this.defaultPlugin.setAutoSetProperties(enabled);
        }
    }

    public void setPluginClassAttribute(String namespaceUri, String attrName) {
        this.pluginClassAttrNs = namespaceUri;
        this.pluginClassAttr = attrName;
    }

    public void setPluginIdAttribute(String namespaceUri, String attrName) {
        this.pluginIdAttrNs = namespaceUri;
        this.pluginIdAttr = attrName;
    }

    public void postRegisterInit(String matchPattern) throws PluginConfigurationException {
        Log log = LogUtils.getLogger(this.digester);
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("PluginCreateRule.postRegisterInit: rule registered for pattern [" + this.pattern + "]"));
        }
        if (this.digester == null) {
            this.initException = new PluginConfigurationException("Invalid invocation of postRegisterInit: digester not set.");
            throw this.initException;
        }
        if (this.pattern != null) {
            this.initException = new PluginConfigurationException("A single PluginCreateRule instance has been mapped to multiple patterns; this is not supported.");
            throw this.initException;
        }
        if (matchPattern.indexOf(42) != -1) {
            this.initException = new PluginConfigurationException("A PluginCreateRule instance has been mapped to pattern [" + matchPattern + "]." + " This pattern includes a wildcard character." + " This is not supported by the plugin architecture.");
            throw this.initException;
        }
        if (this.baseClass == null) {
            Class clazz = this.baseClass = class$java$lang$Object == null ? (class$java$lang$Object = PluginCreateRule.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (this.defaultPlugin != null) {
            if (!this.baseClass.isAssignableFrom(this.defaultPlugin.getPluginClass())) {
                this.initException = new PluginConfigurationException("Default class [" + this.defaultPlugin.getPluginClass().getName() + "] does not inherit from [" + this.baseClass.getName() + "].");
                throw this.initException;
            }
            try {
                this.defaultPlugin.init(this.digester);
            }
            catch (PluginWrappedException pwe) {
                throw new PluginConfigurationException(pwe.getMessage(), pwe.getCause());
            }
        }
        this.pattern = matchPattern;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Rules oldRules;
        Log log = this.digester.getLogger();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("PluginCreateRule.begin: pattern=[" + this.pattern + "]" + " match=[" + this.digester.getMatch() + "]"));
        }
        if (this.initException != null) {
            throw this.initException;
        }
        String currMatch = this.digester.getMatch();
        if (currMatch.length() == this.pattern.length()) {
            if (this.localRules != null) {
                throw new PluginAssertionFailure("Begin called when localRules is not null.");
            }
            oldRules = (PluginRules)this.digester.getRules();
            this.localRules = new PluginRules(this, (PluginRules)oldRules);
            PluginManager pluginManager = this.localRules.getPluginManager();
            Declaration currDeclaration = null;
            if (debug) {
                log.debug((Object)("PluginCreateRule.begin: installing new plugin: oldrules=" + oldRules.toString() + ", localrules=" + this.localRules.toString()));
            }
            String pluginClassName = this.pluginClassAttrNs == null ? attributes.getValue(this.pluginClassAttr) : attributes.getValue(this.pluginClassAttrNs, this.pluginClassAttr);
            String pluginId = this.pluginIdAttrNs == null ? attributes.getValue(this.pluginIdAttr) : attributes.getValue(this.pluginIdAttrNs, this.pluginIdAttr);
            if (pluginClassName != null) {
                currDeclaration = pluginManager.getDeclarationByClass(pluginClassName);
                if (currDeclaration == null) {
                    currDeclaration = new Declaration(pluginClassName);
                    try {
                        currDeclaration.init(this.digester);
                    }
                    catch (PluginWrappedException pwe) {
                        throw new PluginInvalidInputException(pwe.getMessage(), pwe.getCause());
                    }
                    pluginManager.addDeclaration(currDeclaration);
                }
            } else if (pluginId != null) {
                currDeclaration = pluginManager.getDeclarationById(pluginId);
                if (currDeclaration == null) {
                    throw new PluginInvalidInputException("Plugin id [" + pluginId + "] is not defined.");
                }
            } else if (this.defaultPlugin != null) {
                currDeclaration = this.defaultPlugin;
            } else {
                throw new PluginInvalidInputException("No plugin class specified for element " + this.pattern);
            }
            this.digester.setRules(this.localRules);
            currDeclaration.configure(this.digester, this.pattern);
            Class pluginClass = currDeclaration.getPluginClass();
            Object instance = pluginClass.newInstance();
            this.getDigester().push(instance);
            if (debug) {
                log.debug((Object)("PluginCreateRule.begin: pattern=[" + this.pattern + "]" + " match=[" + this.digester.getMatch() + "]" + " pushed instance of plugin [" + pluginClass.getName() + "]"));
            }
            this.digester.setRules(oldRules);
            ((PluginRules)oldRules).beginPlugin(this);
        }
        oldRules = this.digester.getRules();
        if (debug) {
            log.debug((Object)("PluginCreateRule.begin: firing nested rules: oldrules=" + oldRules.toString() + ", localrules=" + this.localRules.toString()));
        }
        this.digester.setRules(this.localRules);
        this.delegateBegin(namespace, name, attributes);
        this.digester.setRules(oldRules);
        if (debug) {
            log.debug((Object)("PluginCreateRule.begin: restored old rules to oldrules=" + oldRules.toString()));
        }
    }

    public void body(String namespace, String name, String text) throws Exception {
        Rules oldRules = this.digester.getRules();
        this.digester.setRules(this.localRules);
        this.delegateBody(namespace, name, text);
        this.digester.setRules(oldRules);
    }

    public void end(String namespace, String name) throws Exception {
        Rules oldRules = this.digester.getRules();
        this.digester.setRules(this.localRules);
        this.delegateEnd(namespace, name);
        this.digester.setRules(oldRules);
        String currMatch = this.digester.getMatch();
        if (currMatch.length() == this.pattern.length()) {
            this.localRules = null;
            ((PluginRules)oldRules).endPlugin(this);
            this.digester.pop();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void delegateBegin(String namespace, String name, Attributes attributes) throws Exception {
        Log log = this.digester.getLogger();
        boolean debug = log.isDebugEnabled();
        String match = this.digester.getMatch();
        List rules = this.digester.getRules().match(namespace, match);
        Iterator ri = rules.iterator();
        while (ri.hasNext()) {
            Rule rule = (Rule)ri.next();
            if (debug) {
                log.debug((Object)("  Fire begin() for " + rule));
            }
            rule.begin(namespace, name, attributes);
        }
    }

    public void delegateBody(String namespace, String name, String text) throws Exception {
        Log log = this.digester.getLogger();
        boolean debug = log.isDebugEnabled();
        String match = this.digester.getMatch();
        List rules = this.digester.getRules().match(namespace, match);
        Iterator ri = rules.iterator();
        while (ri.hasNext()) {
            Rule rule = (Rule)ri.next();
            if (debug) {
                log.debug((Object)("  Fire body() for " + rule));
            }
            rule.body(namespace, name, text);
        }
    }

    public void delegateEnd(String namespace, String name) throws Exception {
        Log log = this.digester.getLogger();
        boolean debug = log.isDebugEnabled();
        String match = this.digester.getMatch();
        List rules = this.digester.getRules().match(namespace, match);
        ListIterator ri = rules.listIterator();
        while (ri.hasNext()) {
            ri.next();
        }
        while (ri.hasPrevious()) {
            Rule rule = (Rule)ri.previous();
            if (debug) {
                log.debug((Object)("  Fire end() for " + rule));
            }
            rule.end(namespace, name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

