/*
 * Created on 2005. 5. 4.
 */
package net.javajigi.security.service.impl;

import net.javajigi.security.dao.UserDAO;
import net.javajigi.security.model.User;
import net.javajigi.security.service.PasswordMisMatchException;
import net.javajigi.security.service.SecurityService;
import net.javajigi.security.service.UserNotFoundException;

/**
 * @author Administrator
 */
public class SecurityServiceImpl implements SecurityService {
	private UserDAO userDAO = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.javajigi.security.service.SecurityService#setUserDAO(net.javajigi.security.dao.UserDAO)
	 */
	public void setUserDAO(UserDAO newUserDAO) {
		this.userDAO = newUserDAO;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.javajigi.security.service.SecurityService#authenticate(java.lang.String,
	 *      java.lang.String)
	 */
	public boolean authenticate(String newUserId, String newPassword)
			throws UserNotFoundException, PasswordMisMatchException {
		if (newUserId == null) {
			throw new NullPointerException(" ̵ Null   ϴ.");
		}
		
		if (newPassword == null) {
			throw new NullPointerException("йȣ Null   ϴ.");
		}
		
		User user = userDAO.findUser(newUserId);
		if (user == null) {
			throw new UserNotFoundException(newUserId
					+ "  ̵  ڰ  ʽϴ.");
		}

		if (!newPassword.equals(user.getPassword())) {
			throw new PasswordMisMatchException(newUserId
					+ "  йȣ  ʽϴ.");
		}

		return true;
	}

}
