/*
 * Created on 2005. 5. 11.
 */
package net.javajigi.timer;

import java.io.File;
import java.util.TimerTask;

import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

/**
 * @author Administrator
 */
public class Log4JConfRefreshTimerTask extends TimerTask {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger
			.getLogger(Log4JConfRefreshTimerTask.class);

	private String filePath = null;

	private long oldLogFileLastModifiedTime = 0;

	private File logFile = null;

	/**
	 *  
	 */
	public Log4JConfRefreshTimerTask(String logFilePath) {
		this.filePath = logFilePath;

		logFile = new File(logFilePath);

		if (logFile.lastModified() != 0) {
			oldLogFileLastModifiedTime = logFile.lastModified();

			if (logger.isDebugEnabled()) {
				logger.debug("Old Last Modified Time : "
						+ oldLogFileLastModifiedTime);
			}
		} else {
			logger.error("Log   ʽϴ.");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		long newLastModifiedTime = logFile.lastModified();

		if (oldLogFileLastModifiedTime != newLastModifiedTime) {
			if( logger.isInfoEnabled() ) {
				logger.info("Log4J  log4j.xml Ǿϴ.");
			}
			
			oldLogFileLastModifiedTime = newLastModifiedTime;
			DOMConfigurator.configure(filePath);
		} else {
			if( logger.isInfoEnabled() ) {
				logger.info("INFO Level");
			}
			if( logger.isDebugEnabled() ) {
				logger.debug("DEBUG Level");
			}

			logger.warn("WARN LEVEL");			
			logger.error("ERROR LEVEL");
		}
	}
}
