<%@ page contentType="text/html;charset=euc-kr" session="true" %>
<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>
<%@ page import="unisql.itrack.*" %>
<%@ page import="com.oreilly.servlet.MultipartRequest" %>
<% request.setCharacterEncoding("euc-kr"); %>
<% response.setHeader("Cache-Control","No-cache");
%>

<% ITrackHTML.Head(out, "ITrack");  %>

<BODY>

<%
  String working_table = (String) session.getAttribute(ITrackJsp.SESSION_KEY_WORKING_TABLE);
  String userid = (String) session.getAttribute(ITrackJsp.SESSION_KEY_USERID);
  String username = (String) session.getAttribute(ITrackJsp.SESSION_KEY_USERNAME);
  String info_table = (String) session.getAttribute(ITrackJsp.SESSION_KEY_INFO_TABLE);
  if (userid == null) {
    ITrackHTML.writeErrorMsg(out, ITrackMsg.session_invalid);
    return;
  }

  ITrackIssueInfo[] issueInfoArr = ITrackIssueInfo.getIssueInfoArray(info_table);

  String tmpDir = ITrackFile.getFileUploadTmpDir();
  MultipartRequest mReq = new MultipartRequest(request, tmpDir, request.getContentLength(), "euc-kr", new ITrackFileRenamePolicy(tmpDir, userid));

  String opcode = mReq.getParameter("opcode");
  if (opcode == null)
    opcode = "";

  if (opcode.equals("load")) {
    String url = "issue_new_form.jsp?template_filename=" + URLEncoder.encode(mReq.getParameter("template_filename"));
    ITrackJsp.redirect(response, url);
  }
  else if (opcode.equals("delete")) {
    String templateFilename = mReq.getParameter("template_filename");
    ITrackFile.deleteTemplateFile(working_table, userid, templateFilename);
    ITrackJsp.redirect(response, "issue_new_form.jsp");
  }
  else if (opcode.equals("save")) {
    Enumeration e = mReq.getParameterNames();
    HashMap map = new HashMap();
    
	for (; e.hasMoreElements(); )
	{
		String key = (String) e.nextElement();
		map.put(key, mReq.getParameter(key));
	}
	
    ITrackTemplate template = new ITrackTemplate(map);
    String templateFilename = mReq.getParameter("template_new_filename");
    ITrackFile.saveTemplateFile(working_table, userid, templateFilename, template);
    String url = "issue_new_form.jsp?template_filename=" + URLEncoder.encode(templateFilename);
    ITrackJsp.redirect(response, url);
  } 
  else {
    String[] insertResult;

    try {
      insertResult = ITrackIssueInfo.insertIssue(issueInfoArr, mReq, username, working_table);

      if (insertResult[0] != null && insertResult[0].length() > 0) {
        String emailaddr = ITrackDB.getMailAddress(insertResult[1]);
        StringBuffer mailContent = new StringBuffer("");
        String ids = ITrackDB.appendMailContent(mailContent, working_table, insertResult[0]);

        if (mReq.getParameter("code_name").trim().equals("ġ")) {
        	ITrackJsp.sendMail(username, emailaddr, "[ITrack] " + ids + "̽  [ġ] : " + mReq.getParameter("title"), mailContent.toString());
        } else {
	        ITrackJsp.sendMail(username, emailaddr, "[ITrack] " + ids + "̽  : " + mReq.getParameter("title"), mailContent.toString());
        }
      }
    } finally {
      ITrackJsp.deleteTmpUploadFiles(mReq);
    }

    ITrackJsp.redirect(response, ITrackJsp.makeDetailViewURL(insertResult[0]));
  }
%>

</BODY>
