package unisql.itrack;

import java.util.*;
import java.io.*;
import javax.servlet.http.*;
import com.oreilly.servlet.*;
import javax.mail.internet.*;
import javax.mail.*;

abstract public class ITrackJsp {

static final boolean debugMode = true;

/*=======================================================================
 |      PUBLIC VARIABLES
 =======================================================================*/

public static final String SESSION_KEY_USERID = "userid";
public static final String SESSION_KEY_USERNAME = "username";
public static final String SESSION_KEY_WORKING_TABLE = "working_table";
public static final String SESSION_KEY_INFO_TABLE = "info_table";

public static final int ISSUE_DISPLAY_TOP = 0;
public static final int ISSUE_DISPLAY_COLUMNS = 3;

public static final int NUM_SEARCH_FORM_WHERE = 20;
public static final int NUM_SEARCH_FORM_ORDERBY = 10;

public static final String ORDERBY_ASC = "ASC";
public static final String ORDERBY_DESC = "DESC";

public static final String ITRACK_HOME_URL = "http://xxx.xxx.xxx"; //FIXME: set your URL

public static final int ITRACK_NONE = 0;
public static final int ITRACK_OPEN = 1;
public static final int ITRACK_RESOLVE = 2;
public static final int ITRACK_CLOSE = 3;
public static final int ITRACK_REOPEN = 4;

/*=======================================================================
 |      PRIVATE VARIABLES
 =======================================================================*/

/*=======================================================================
 |      CONSTRUCTOR
 =======================================================================*/

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

public static void redirectHome(HttpServletResponse response)
	throws IOException
{
  redirect(response, ITRACK_HOME_URL);
}

public static String getImageFile(String status)
{
  if (status == null)
    return "";

  if (status.equals("̰"))
    return "image/orange.gif";

  if (status.equals("ذ"))
    return "image/yellow.gif";

  return "image/green.gif";
}

public static String makeDetailViewURL()
{
  return "issue_view_detail.jsp";
}

public static String makeDetailViewURL(String id)
{
  return makeDetailViewURL() + "?id=" + id;
}

public static String makeDetailViewURL(String[] id)
{
  StringBuffer buf = new StringBuffer(makeDetailViewURL());

  if (id == null)
    return buf.toString();

  buf.append("?");
  for (int i=0 ; i < id.length ; i++) {
    if (i != 0)
      buf.append("&");

    buf.append("id=");
    buf.append(id[i]);
  }

  return buf.toString();
}

public static void deleteTmpUploadFiles(MultipartRequest mReq)
{
  if (mReq == null)
    return;

  for (Enumeration e = mReq.getFileNames() ; e.hasMoreElements() ; ) {
    String s = (String) e.nextElement();
    File f = mReq.getFile(s);
    if (f != null)
      f.delete();
  }
}

public static String[] remakeIdArr(String[] idArr)
{
  if (idArr == null)
    return null;

  String[] tmp = new String[idArr.length];
  int len = 0;

  for (int i=0 ; i < idArr.length ; i++) {
    if (idArr[i] != null && idArr[i].length() > 0)
      tmp[len++] = idArr[i];
  }

  String[] retArr = new String[len];
  System.arraycopy(tmp, 0, retArr, 0, len);
  return retArr;
}

public static void redirect(HttpServletResponse response, String url)
	throws IOException
{
  //response.sendRedirect(response.encodeRedirectURL(url));
  response.sendRedirect(url);
}

public static void sendMail(String username, String to, String subject, String content)
{
  if (to == null || to.length() == 0)
    return;

  try {
    boolean send_mail_flag = true;

    if (send_mail_flag) {
      Properties props = new Properties();
      props.put("mail.smtp.host", "your mail server ip"); //FIXME: set your mail server ip

      Session msgSession = Session.getDefaultInstance(props, null);
      //  msgSession.setDebug(debug);

      MimeMessage msg = new MimeMessage(msgSession);
      InternetAddress addrFrom = new InternetAddress(ITrackDB.getMailAddress(username));
      msg.setFrom(addrFrom);
      msg.setSubject(subject, "euc-kr");
      msg.setSentDate(new Date(System.currentTimeMillis()));
      InternetAddress addrTo = new InternetAddress(to);
      msg.setRecipient(Message.RecipientType.TO, addrTo);
      msg.setContent(content, "text/html;charset=euc-kr");
      Transport.send(msg);
    }
  } catch (Exception e) {
    System.err.println("============ send mail error ================");
    System.err.println(e);
    System.err.println("=============================================");
  }
}

/*=======================================================================
 |      PACKAGE ACCESS METHODS
 =======================================================================*/

static String getDSName()
{
    return ("itrack/itrackdb");
}

static String concatId(String[] strArr, String delimiter)
{
  if (strArr == null)
    return null;

  StringBuffer buf = new StringBuffer("");

  for (int i=0 ; i < strArr.length ; i++) {
    if (strArr[i] != null && strArr[i].length() > 0) {
      if (buf.length() > 0)
	buf.append(delimiter);
      buf.append("'");
      buf.append(strArr[i]);
      buf.append("'");
    }
  }

  return buf.toString();
}

/*=======================================================================
 |      PRIVATE METHODS
 =======================================================================*/

}
