package unisql.itrack;

import java.sql.*;
import java.math.*;
import javax.naming.*;
import java.util.Hashtable;
import java.util.Iterator;

public class ITrackIssueValue {

/*=======================================================================
 |      PRIVATE VARIABLES
 =======================================================================*/

private Hashtable valueTable;

/*=======================================================================
 |      CONSTRUCTOR
 =======================================================================*/

public ITrackIssueValue(String openUserName) throws SQLException
{
  valueTable = new Hashtable(5);
  /*
  put("status", "̰");
  put("opened_date", (new Date(System.currentTimeMillis())).toString());
  put("opened_by", openUserName);

  if (ITrackJsp.debugMode) {
    put("title", "title");
    put("path", "1");
    put("assigned", "ö");
    put("issue_type", "ɰ");
    put("severity", "1");
    put("priority", "1");
    put("platform", "os");
    put("issue_build_number", "issue_build_number");
    put("how_found", "ad hoc");
    put("description", "󼼼");
    put("repro_step", "");
    put("issue_source", "");
  }
  */
}

public ITrackIssueValue(String openUserName, ITrackTemplate template) throws SQLException
{
  valueTable = new Hashtable(5);
  
  if (template == null) {
	  put("description", ":\n\n:\n\n:\n\n");
	  return;
  }
  
  for (Iterator iter = template.map.keySet().iterator(); iter.hasNext();)
  {
	String key = (String) iter.next();
	String value = (String) template.map.get(key);
	
	put(key, value);
  }
}

public ITrackIssueValue(String tablename, String[] id)
	throws SQLException, NamingException
{
  valueTable = new Hashtable(5);

  Object[][] values = selectIssueValues(null, tablename, id);
  if (values == null || values.length <= 1)
    return;

  String attr_name;
  Object pivot;
  boolean insertFlag;

  for (int i=0 ; i < values[0].length ; i++) {
    attr_name = (String) values[0][i];
    pivot = values[1][i];
    if (pivot == null)
      continue;
    insertFlag = true;
    for (int j=2 ; j < values.length ; j++) {
      if (!pivot.equals(values[j][i])) {
	insertFlag = false;
	break;
      }
    }
    if (insertFlag) {
      put(attr_name, pivot);
    }
  }
}

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

/*=======================================================================
 |      PACKAGE ACCESS METHODS
 =======================================================================*/

Object getObject(String key)
{
  return valueTable.get(key);
}

String getString(String key)
{
  Object value = valueTable.get(key);

  if (value == null)
    return "";

  if (value instanceof String)
    return (String) value;
  if (value instanceof Date)
    return ((Date) value).toString();

  return "";
}

static Object[][] selectIssueValues(Connection con, String tablename, String[] id)
	throws SQLException, NamingException
{
  Object[][] resultArr = null;
  int numResult = 0;
  int cols = 0;
  boolean needclose;

  if (con == null)
    needclose = true;
  else
    needclose = false;

  if (id == null || id.length == 0)
    return null;

  try {
    StringBuffer query = new StringBuffer("select * from ");
    query.append(tablename);
    query.append(" where id in { ");
    query.append(ITrackJsp.concatId(id, ", "));
    query.append(" } ");

    if (con == null)
      con = ITrackDB.getConnection();
    PreparedStatement pstmt = con.prepareStatement(query.toString());

    ResultSet rs = pstmt.executeQuery();
    ResultSetMetaData rsmd = rs.getMetaData();
    cols = rsmd.getColumnCount();

    resultArr = new Object[id.length+1][cols];
    for (int i=0 ; i < cols ; i++) {
      resultArr[numResult][i] = rsmd.getColumnName(i+1);
    }
    numResult++;

    while (rs.next()) {
      for (int i=0 ; i < cols ; i++) {
	resultArr[numResult][i] = rs.getObject(i+1);
      }
      numResult++;
    }
    rs.close();
    pstmt.close();
  } finally {
    if (needclose)
      ITrackDB.closeConnection(con);
  }

  Object[][] tmp = new Object[numResult][cols];
  System.arraycopy(resultArr, 0, tmp, 0, numResult);
  return tmp;
}

/*=======================================================================
 |      PRIVATE METHODS
 =======================================================================*/

private void put(String key, Object value)
{
  if (value == null)
    return;

  valueTable.put(key, value);
}

}
