package unisql.itrack;

import java.sql.*;
import javax.sql.*;
import java.io.*;
import unisql.sql.*;
import javax.naming.*;

abstract public class ITrackDB {

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

static public Connection getConnection()
    throws SQLException, NamingException
{
  String dsname = ITrackJsp.getDSName();

  Context initCtx = new InitialContext();
  Context envCtx = (Context) initCtx.lookup("java:/comp/env");
  DataSource ds = (DataSource) envCtx.lookup(dsname);
  return ds.getConnection();
}

static public Object[] selectQuery(Connection con, String query, Object[] value, int value_length)
	throws SQLException
{
  Object	result[];

  PreparedStatement pstmt = con.prepareStatement(query);
  for (int i=0 ; i < value_length ; i++) {
    pstmt.setObject(i+1, value[i]);
  }
  ResultSet rs = pstmt.executeQuery();

  int cols = rs.getMetaData().getColumnCount();
  result = new Object[cols];

  rs.next();

  for (int i=0 ; i < cols ; i++) {
    result[i] = rs.getObject(i + 1);
  }

  rs.close();
  pstmt.close();

  return result;
}

static public int executeQuery(Connection con, String query, Object[] value, int value_length)
	throws SQLException
{
  int	res;
  PreparedStatement pstmt = con.prepareStatement(query);
  for (int i=0 ; i < value_length ; i++) {
    pstmt.setObject(i + 1, value[i]);
  }
  res = pstmt.executeUpdate();
  pstmt.close();
  return res;
}

static public void closeConnection(Connection con)
{
  try {
    if (con != null) {
      con.rollback();
      con.setAutoCommit(true);
      con.close();
    }
  } catch (Exception e) {
  }
}

static public UniSQLOID insertFile(Connection con, File f, String username, String filename)
        throws IOException, SQLException
{
  if (f == null)
    return null;

  FileInputStream	fin = null;
  UniSQLOID		fileObj = null;

  try {
    String query = "call new_lo() on class itrack_attach_file";
    Object[] resultValues = ITrackDB.selectQuery(con, query, null, 0);

    fileObj = (UniSQLOID) resultValues[0];

    fin = new FileInputStream(f);
    fileObj.saveGLO(fin);
    fin.close();
    fin = null;

    String[] attrNames = {"username", "filename"};
    String[] attrValues = { username, filename};

    fileObj.setValues(attrNames, attrValues);
  } finally {
    if (fin != null)
      fin.close();
  }

  return fileObj;
}

private static boolean isContainDescriptionInWhereList(String[][] whereList)
{
  for (int i = 0; i < whereList.length; i++)
  {
    if (whereList[i][1].equals("description"))
      return true;
  }
		
  return false;
}

public static Object[][] makeQuery(ITrackIssueInfo[] infoArr, String[] selectList, String[][] whereList, String[][] orderbyList, String tablename)
{
  Object[] bindValue = new Object[whereList.length];
  int bindLen = 0;

  StringBuffer query = new StringBuffer("select ");
  
  if (isContainDescriptionInWhereList(whereList)) {
    query.append("distinct ");
  }
  
  for (int i=0 ; i < selectList.length ; i++) {
    if (i != 0)
      query.append(", ");
    query.append(selectList[i]);
  }

  query.append("\n from ");
  query.append(tablename);

  if (isContainDescriptionInWhereList(whereList)) {
    query.append(", table(description) t(d) ");
  } else {
    query.append(" ");
  }

  StringBuffer where = new StringBuffer("");
  String conj, attr, op, val;
  for (int i=0 ; i < whereList.length ; i++) {
    conj = whereList[i][0];
    attr = whereList[i][1];
    op = whereList[i][2];
    val = whereList[i][3];
    if (conj == null || attr == null || op == null || val == null)
      continue;
    if (attr.length() == 0)
      continue;
      
    if (!where.toString().trim().equals("")) {
      where.append(conj);
      where.append(" ");
    }

    if (attr.equals("description"))
    {
      where.append("t.d");
    } else {
      where.append(attr);
    }
    where.append(" ");
    
    if (op.length() > 0) {
      if (op.equals("in") || op.equals("not in")) {
	where.append(op);

	if (val.trim().startsWith("(")) {	/* } */
	  where.append(" ");
	  where.append(val);
	  where.append(" ");
	}
	else {
	  String[] valArr = ITrackIssueInfo.selectValueSplit(val);
	  where.append(" {");
	  for (int j=0 ; j < valArr.length ; j++) {
	    if (j != 0)
	      where.append(", ");
	    where.append("'");
	    where.append(valArr[j]);
	    where.append("'");
	  }
	  where.append("} ");
	}
      }
      else {
	//String attr_type = ITrackIssueInfo.getDbAttributeType(infoArr, attr);
	if (attr.equals("path") && op.equals("=")) {
	  where.append(" like ");
	  where.append("'");
	  where.append(val);
	  where.append("%' ");
	}
	else {
	  where.append(op);
	  where.append(" ");
	  if (val.toUpperCase().startsWith("SYSDATE") 
	      || val.toUpperCase().startsWith("SYS_DATE")) {
	    where.append(" " + val + " "); 
	  }
	  else 
	  {
	    appendStringLiteral(where, val);
	  }
	}

	/*
	where.append(" ? ");
	bindValue[bindLen++] = val;
	*/
      }
    }
    else {
      where.append(val);
      where.append(" ");
    }
  }

  if (where.length() > 0) {
    query.append("\n where ");
    query.append(where.toString());
  }

  StringBuffer orderby = new StringBuffer("");
  for (int i=0 ; i < orderbyList.length ; i++) {
    if (orderbyList[i][0] == null || orderbyList[i][0].length() == 0)
      continue;
    if (orderbyList[i][1] == null)
      continue;
    if (orderby.length() > 0)
      orderby.append(", ");
    orderby.append(orderbyList[i][0]);
    orderby.append(" ");
    orderby.append(orderbyList[i][1]);
    orderby.append(" ");
  }

  if (orderby.length() > 0) {
    query.append("\n order by ");
    query.append(orderby.toString());
  }

  Object[][] result = new Object[2][];
  result[0] = new String[1];
  result[0][0] = query.toString();
  result[1] = new Object[bindLen];
  System.arraycopy(bindValue, 0, result[1], 0, bindLen);

  return result;
}

public static String getMailAddress(String username)
{
  if (username == null || username.length() == 0)
    return null;

  Connection con = null;

  try {
    con = getConnection();
    String query = "select email from itrack_info_user where user_name = ?";
    Object[] bindValue = new Object[1];
    bindValue[0] = username;
    Object[] resultValue = selectQuery(con, query, bindValue, 1);

    return ((String) resultValue[0]);
  } catch (Exception e) {
    return null;
  } finally {
    if (con != null)
      closeConnection(con);
  }
}

public static String appendMailContent(StringBuffer content, String working_table, String id)
{
  String[] idArr = new String[1];
  idArr[0] = id;
  return appendMailContent(content, working_table, idArr);
}

public static String appendMailContent(StringBuffer content, String working_table, String[] idArr)
{
  Connection con = null;
  String id = "";

  try {
    StringBuffer query = new StringBuffer("select id, status, title, description from ");
    query.append(working_table);
    query.append(" where id in { ");
    query.append(ITrackJsp.concatId(idArr, ", "));
    query.append(" } ");

    con = getConnection();
    Statement stmt = con.createStatement();
    ResultSet rs = stmt.executeQuery(query.toString());

    content.append("<table border=0>");
    content.append("\n");
    while (rs.next()) {
      content.append("<tr>");
      content.append("<td>");
      content.append("<a href=\"");
      content.append(ITrackJsp.ITRACK_HOME_URL);
      content.append("?id=");
      content.append(rs.getString(1));
      id += rs.getString(1) + " ";
      content.append("\">");
      content.append(rs.getString(1));
      content.append("</a>");
      content.append("\n");
      content.append("<td> &nbsp;");
      content.append(rs.getString(2));
      content.append("\n");
      content.append("<td> &nbsp;");
      content.append(rs.getString(3));
      content.append("\n");
      content.append("<tr>");
      content.append("\n");

      content.append("<table border=0 celpadding=3 cellspacing=3 width=690>\n");

      String[] description = (String[]) rs.getObject(4);
      int numItem = description.length / 2;
      for (int i = numItem - 1 ; i >= 0 ; i--) {
      	content.append("<tr>");
      	content.append("<td colspan=2>");

      	content.append("<B> -");
      	content.append(description[i*2].replaceAll("\n", "<BR>&nbsp;&nbsp;&nbsp;\n"));
      	content.append("</B>\n");

      	content.append("<tr>");
      	content.append("<td width=10>");
      	content.append("<td>");
        String s = description[i*2+1];
        if (s == null)
          s = "";
        s = s.replaceAll("<", "&lt;").replaceAll("\n", "<BR>");
        content.append(s + '\n');
      }

      content.append("</table>\n");
    }
    content.append("</table>");
    content.append("\n");

    rs.close();
    stmt.close();
  } catch (Exception e) {
  } finally {
    if (con != null)
      closeConnection(con);
  }
  
  return id;
}

public static String[] getUserList(String team)
	throws SQLException, NamingException
{
  Connection con = null;
  String[] users;

  try {
    con = getConnection();
    String query = "select user_name from itrack_info_user where team LIKE ? order by team, user_name";
    PreparedStatement pstmt = con.prepareStatement(query, ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
    pstmt.setString(1, team);
    ResultSet rs = pstmt.executeQuery();
    rs.last();
    users = new String[rs.getRow()];
    rs.beforeFirst();
    for (int i=0 ; rs.next() ; i++) {
      users[i] = rs.getString(1);
    }
    rs.close();
    pstmt.close();
  } finally {
    if (con != null)
      closeConnection(con);
  }
  return users;
}

/*=======================================================================
 |      PACKAGE ACCESS METHODS
 =======================================================================*/

/*=======================================================================
 |      PRIVATE METHODS
 =======================================================================*/

private static void appendStringLiteral(StringBuffer buf, String value)
{
  String[] valArr = value.split("'");
  for (int i=0 ; i < valArr.length ; i++) {
    buf.append(" '");
    buf.append(valArr[i]);
    buf.append("' ");
  }
}

}
