/*
 * Decompiled with CFR 0.152.
 */
package imhotep.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGStylable;

public class SVGStyleSupport {
    private SVGStyleSupport() {
    }

    public static String getProperty(Node n, String key) {
        if (n instanceof SVGStylable) {
            try {
                return SVGStyleSupport.getProperty(((SVGStylable)n).getStyle(), key);
            }
            catch (Exception e) {
                return SVGStyleSupport.getComputedProperty((Element)n, key);
            }
        }
        return null;
    }

    public static void setProperty(Node n, String key, String value) {
        if (n instanceof SVGStylable) {
            try {
                SVGStyleSupport.setProperty(((SVGStylable)n).getStyle(), key, value);
            }
            catch (Exception e) {
                SVGStyleSupport.setComputedProperty((Element)n, key, value);
            }
        }
    }

    public static void removeProperty(Node n, String key) {
        if (n instanceof SVGStylable) {
            SVGStyleSupport.removeProperty(((SVGStylable)n).getStyle(), key);
        }
    }

    public static String getProperty(CSSStyleDeclaration style, String key) {
        return style.getPropertyValue(key);
    }

    public static void setProperty(CSSStyleDeclaration style, String key, String value) {
        if (value == null || "".equals(value)) {
            SVGStyleSupport.removeProperty(style, key);
            return;
        }
        try {
            String priority = style.getPropertyPriority(key);
            style.setProperty(key, value, priority);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeProperty(CSSStyleDeclaration style, String key) {
        style.removeProperty(key);
    }

    public static String getComputedProperty(Element ele, String key) {
        Map styleMap = SVGStyleSupport.toStyleMap(ele.getAttribute("style"));
        return (String)styleMap.get(key);
    }

    public static void setComputedProperty(Element ele, String key, String value) {
        Map styleMap = SVGStyleSupport.toStyleMap(ele.getAttribute("style"));
        styleMap.put(key, value);
        String newStyle = SVGStyleSupport.toStyleText(styleMap);
        ele.setAttribute("style", newStyle);
    }

    private static Map toStyleMap(String styleText) {
        HashMap<String, String> map = new HashMap<String, String>();
        int s = 0;
        int e = styleText.indexOf(58);
        String value = null;
        try {
            while (true) {
                String key = styleText.substring(s, e);
                s = e + 1;
                if ((e = styleText.indexOf(59, s)) == -1) {
                    e = styleText.length();
                }
                value = styleText.substring(s, e);
                s = e + 1;
                e = styleText.indexOf(58, s);
                map.put(key, value);
            }
        }
        catch (Exception exception) {
            return map;
        }
    }

    private static String toStyleText(Map styleMap) {
        StringBuffer b = new StringBuffer();
        Iterator it = styleMap.keySet().iterator();
        Object value = null;
        while (it.hasNext()) {
            Object key = it.next();
            value = styleMap.get(key);
            b.append(key);
            b.append(":");
            b.append((Object)value);
            if (!it.hasNext()) continue;
            b.append(";");
        }
        return b.toString();
    }

    public static boolean validateStyle(String styleKey, String newValue) {
        return false;
    }
}

