/*
 * Decompiled with CFR 0.152.
 */
package imhotep.util;

import imhotep.util.SVGAttributeSupport;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;

public class SVGNodeUtilities
implements SVGSyntax {
    private SVGNodeUtilities() {
    }

    public static boolean isValidateNode(Node node) {
        if (node == null) {
            return false;
        }
        return node.getNodeType() != 3 || !"".equals(node.getNodeValue().trim());
    }

    public static String getName(Node n) {
        if (n == null) {
            return "Null Node...";
        }
        String name = SVGAttributeSupport.getAttribute(n, "id");
        if (name == null || "".equals(name)) {
            name = n.getNodeName();
        }
        return name;
    }

    public static boolean isDrawable(Node n) {
        if (n instanceof SVGLineElement) {
            return true;
        }
        if (n instanceof SVGEllipseElement) {
            return true;
        }
        if (n instanceof SVGCircleElement) {
            return true;
        }
        if (n instanceof SVGRectElement) {
            return true;
        }
        if (n instanceof SVGPathElement) {
            return true;
        }
        if (n instanceof SVGPolylineElement) {
            return true;
        }
        return n instanceof SVGPolygonElement;
    }
}

