/*
 * Decompiled with CFR 0.152.
 */
package imhotep.properties.attribute.action;

import imhotep.editor.SVGEditorEvent;
import imhotep.editor.SVGPalette;
import imhotep.menu.Menu;
import imhotep.util.NodeSelection;
import imhotep.util.SVGAttributeSupport;
import javax.swing.JOptionPane;
import org.w3c.dom.Node;

public class Attribute
extends Menu {
    protected String key;
    private Node node;
    private String newValue;

    public void actionPerformed(Object source) {
        if (source instanceof String) {
            this.key = (String)source;
        }
        super.actionPerformed(source);
    }

    public void run() {
        super.run();
        this.key = null;
    }

    public void editorAdded(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().addSVGModelListener(this);
    }

    public void editorRemoved(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().removeSVGModelListener(this);
    }

    public int prepare() {
        if (this.key != null) {
            NodeSelection ns = this.model().getSelectedNodes();
            this.node = ns.item(ns.getLength() - 1);
            SVGPalette comp = this.palette("imhotep.properties.PropertiesPalette");
            String oldValue = SVGAttributeSupport.getAttribute(this.node, this.key);
            this.newValue = JOptionPane.showInputDialog(comp, null, oldValue);
            if (this.newValue != null && !oldValue.equals(this.newValue.trim())) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public void execute() throws Throwable {
        this.model().attributeEntities(new NodeSelection(this.node), this.key, this.newValue);
    }
}

