/*
 * Decompiled with CFR 0.152.
 */
package imhotep.properties;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.editor.SVGEditorEvent;
import imhotep.editor.SVGPalette;
import imhotep.model.SVGModelEvent;
import imhotep.properties.attribute.AttributeTable;
import imhotep.properties.attribute.AttributeTool;
import imhotep.properties.style.StyleTable;
import imhotep.properties.style.StyleTool;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class PropertiesPalette
extends SVGPalette {
    private static String RESOURCES = "imhotep.properties.resources.PropertiesPalette";
    private static ResourceManager resource = ResourceManager.getBundle(RESOURCES);
    private static CommandManager commands = CommandManager.getSystemBundle();
    protected AttributeTable attr;
    protected AttributeTool attrTool;
    protected StyleTable style;
    protected StyleTool styleTool;

    public PropertiesPalette(JFrame f) {
        super(f);
        super.setTitle(resource.getString("Properties.title"));
    }

    protected JComponent createContentsComponent() {
        Icon attrIcon = resource.getIcon("Properties.attributeIcon");
        Icon paintIcon = resource.getIcon("Properties.paintIcon");
        Icon fontIcon = resource.getIcon("Properties.fontIcon");
        Icon styleIcon = resource.getIcon("Properties.styleIcon");
        String attrTip = resource.getString("Properties.attributeTip");
        String paintTip = resource.getString("Properties.paintTip");
        String fontTip = resource.getString("Properties.fontTip");
        String styleTip = resource.getString("Properties.styleTip");
        this.attr = new AttributeTable();
        this.attrTool = new AttributeTool(this.attr.getActionMap());
        this.style = new StyleTable();
        this.styleTool = new StyleTool(this.style.getActionMap());
        JTabbedPane contents = new JTabbedPane(1);
        contents.addTab("", attrIcon, this.attr.getExtComponent(), attrTip);
        contents.addTab("", styleIcon, this.style.getExtComponent(), styleTip);
        return contents;
    }

    public void editorAdded(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().addSVGModelListener(this);
    }

    public void editorRemoved(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().removeSVGModelListener(this);
        this.attr.setSVGModel(null);
        this.style.setSVGModel(null);
    }

    public void doCloseAction() {
        commands.getCommand("imhotep.menu.view.ViewProperties").actionPerformed(this);
    }

    public void stateChanged(SVGModelEvent evt) {
        this.attr.setSVGModel(evt.getSVGModel());
        this.style.setSVGModel(evt.getSVGModel());
    }

    public void documentChanged(SVGModelEvent evt) {
        this.attr.setSVGModel(evt.getSVGModel());
        this.style.setSVGModel(evt.getSVGModel());
    }

    public void layerChanged(SVGModelEvent evt) {
        this.attr.setSVGModel(evt.getSVGModel());
        this.style.setSVGModel(evt.getSVGModel());
    }

    public void selectionChanged(SVGModelEvent evt) {
        this.attr.setSVGModel(evt.getSVGModel());
        this.style.setSVGModel(evt.getSVGModel());
    }

    public void zoomChanged(SVGModelEvent evt) {
    }

    public void undoChanged(SVGModelEvent evt) {
        this.attr.setSVGModel(evt.getSVGModel());
        this.style.setSVGModel(evt.getSVGModel());
    }
}

