/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model.undo;

import imhotep.model.SVGModel;
import imhotep.model.undo.SVGUndoableEdit;
import imhotep.util.NodeSelection;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGSVGElement;

public class LayerArrangeUndo
extends SVGUndoableEdit {
    protected SVGSVGElement parent;
    protected SVGSVGElement target;
    protected Node refenence;
    protected int type;

    public LayerArrangeUndo(SVGModel model, SVGSVGElement layer, int type) {
        super(model);
        this.type = type;
        this.target = layer;
        this.parent = model.getRootElement();
        if (type == 1) {
            this.refenence = layer.getNextSibling();
        } else if (type == -1) {
            this.refenence = layer.getPreviousSibling();
        }
        this.redo();
    }

    public void redo() throws CannotRedoException {
        if (this.type == 1) {
            this.parent.insertBefore(this.refenence, (Node)this.target);
        } else if (this.type == -1) {
            this.parent.insertBefore((Node)this.target, this.refenence);
        }
        this.svgModel.setSelectedLayer(this.target);
        this.svgModel.setSelectedNodes(new NodeSelection());
    }

    public void undo() throws CannotUndoException {
        if (this.type == 1) {
            this.parent.insertBefore((Node)this.target, this.refenence);
        } else if (this.type == -1) {
            this.parent.insertBefore(this.refenence, (Node)this.target);
        }
        this.svgModel.setSelectedLayer(this.target);
        this.svgModel.setSelectedNodes(new NodeSelection());
    }
}

