/*
 * Decompiled with CFR 0.152.
 */
package imhotep.menu.file;

import core.swing.JFileListChooser;
import imhotep.editor.SVGEditorEvent;
import imhotep.menu.Menu;
import imhotep.menu.file.SaveAsWebDialog;
import imhotep.util.FileFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import org.apache.batik.dom.util.XLinkSupport;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SaveAsWeb
extends Menu {
    private JFileListChooser fileDialog;
    private SaveAsWebDialog dialog;

    private void initDialog() {
        this.fileDialog = new JFileListChooser();
        this.fileDialog.setExtension(FileFilter.SVG);
        this.dialog = new SaveAsWebDialog();
    }

    public int prepare() {
        if (this.fileDialog == null) {
            this.initDialog();
        }
        this.fileDialog.setSelectedFile(new File(this.model().getName()));
        int i = this.fileDialog.showSaveDialog(this.main());
        if (i == 0) {
            File f;
            SVGDocument doc = this.model().getSVGDocument();
            int c = this.dialog.initializeContents(doc, f = this.fileDialog.getSelectedFile().getParentFile());
            if (c > 0) {
                return this.dialog.showDialog(this.main());
            }
            return 0;
        }
        return -1;
    }

    public void execute() throws IOException {
        SaveAsWebDialog.Model m = this.dialog.getEmbededFileModel();
        File saveFile = this.fileDialog.getSelectedFile();
        File root = m.getRootPath();
        int size = m.getRowCount();
        Object key = m.getDefaultValue();
        Element element = null;
        String elementHref = null;
        String name = null;
        String path = null;
        String option = null;
        int i = 0;
        while (i < m.getRowCount()) {
            element = m.getElementAt(i);
            elementHref = m.getHrefAt(i);
            name = m.getNameAt(i);
            path = m.getPathAt(i);
            option = m.getOptionAt(i);
            if (key.equals(option)) {
                File srcFile = null;
                File desFile = null;
                try {
                    byte[] buffer;
                    int r;
                    srcFile = new File(new URI(elementHref));
                    desFile = new File(new File(root, path), name);
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(desFile));
                    while ((r = in.read(buffer = new byte[2048])) != -1) {
                        out.write(buffer, 0, r);
                    }
                    out.flush();
                    out.close();
                    in.close();
                    URI rootURI = root.toURI();
                    URI desURI = desFile.toURI();
                    URI newHref = rootURI.relativize(desURI);
                    this.model().setURLObject(saveFile.toURL());
                    XLinkSupport.setXLinkHref((Element)element, (String)newHref.toASCIIString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        this.model().saveAs(saveFile);
    }

    public void editorAdded(SVGEditorEvent evt) {
        super.setEnabled(evt.getEditable());
    }

    public void editorRemoved(SVGEditorEvent evt) {
        super.setEnabled(evt.getEditable());
    }
}

