/*
 * Decompiled with CFR 0.152.
 */
package imhotep.menu.file;

import core.swing.JFileListChooser;
import core.util.JarLauncher;
import imhotep.editor.SVGEditorEvent;
import imhotep.menu.Menu;
import imhotep.menu.file.NewDialog;
import java.io.File;
import javax.swing.JOptionPane;

public abstract class AbstractExport
extends Menu {
    protected JFileListChooser fileDialog;
    protected NewDialog dialog;

    protected abstract void initDialog();

    protected void createDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new JFileListChooser();
        }
        if (this.dialog == null) {
            this.dialog = new NewDialog();
            this.dialog.searchDialogTitle("Export.title");
        }
    }

    public int prepare() {
        this.createDialog();
        this.initDialog();
        int i = this.fileDialog.showSaveDialog(this.main());
        if (i == 0) {
            System.out.println(this.fileDialog.getSelectedFile());
            return this.dialog.showDialog(this.main());
        }
        return i;
    }

    protected abstract String getTranscoderClassName();

    public void execute() throws Throwable {
        this.model().updateTempFile();
        String w = this.dialog.getWidthValue();
        String h = this.dialog.getHeightValue();
        File srcFile = this.model().getTempFile();
        File desFile = this.fileDialog.getSelectedFile();
        JarLauncher launcher = new JarLauncher();
        launcher.setJarURI("imhotepc.jar");
        launcher.addArgument("-t " + this.getTranscoderClassName());
        launcher.addArgument("-w " + w);
        launcher.addArgument("-h " + h);
        launcher.addArgument("-i " + srcFile.toURI().toASCIIString());
        launcher.addArgument("-o " + desFile.toURI().toASCIIString());
        int r = launcher.execute();
    }

    public void warning(Throwable e) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(this.main(), this.resource().getString("Open.warning"), this.main().title(), 2);
        this.desktop().removeModel(this.model());
    }

    public boolean isRunnable() {
        return true;
    }

    public void editorAdded(SVGEditorEvent evt) {
        super.setEnabled(evt.getEditable());
    }

    public void editorRemoved(SVGEditorEvent evt) {
        super.setEnabled(evt.getEditable());
    }
}

